<?php

use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return view('home.home');
})->name('home');

Route::get('/about', function () {
    return view('about.about');
})->name('about');

Route::get('/services', function () {
    return view('services.services');
})->name('services');
Route::get('/services/single', function () {
    return view('services.single');
})->name('services.single');

Route::get('/cars', function () {
    return view('car.car');
})->name('cars');
Route::get('/cars/single', function () {
    return view('car.single');
})->name('cars.single');
Route::get('/cars/category', function () {
    return view('car.type');
})->name('cars.category');
Route::get('/cars/type', function () {
    return redirect()->route('cars.category');
})->name('cars.type');

Route::get('/blog', function () {
    return view('blog.blog');
})->name('blog');
Route::get('/blog/single', function () {
    return view('blog.single');
})->name('blog.single');

Route::get('/image-gallery', function () {
    return view('image-gallery.image-gallery');
})->name('image-gallery');
Route::get('/video-gallery', function () {
    return view('video-gallery.video-gallery');
})->name('video-gallery');
Route::get('/testimonials', function () {
    return view('testimonials.testimonials');
})->name('testimonials');
Route::get('/faqs', function () {
    return view('faqs.faqs');
})->name('faqs');
Route::get('/contact', function () {
    return view('contact.contact');
})->name('contact');

Route::get('/dashboard', function () {
    return 'Welcome to your dashboard!';
});

Route::fallback(function () {
    return response()->view('404', [], 404);
});
