<?php
use App\Http\Controllers\Api\VehicleApiController;
use App\Http\Controllers\Api\BlogApiController;
use App\Http\Controllers\Api\CategoryApiController;
use App\Http\Controllers\Api\ServiceApiController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\ContactApiController;
use App\Http\Controllers\Api\ImageApiController;
use App\Http\Controllers\Api\VideoApiController;
use App\Http\Controllers\Api\CurrencyApiController;
use App\Http\Controllers\Api\FooterApiController;
use App\Http\Controllers\Api\MakeApiController;
use App\Http\Controllers\Api\TestimonialApiController;
use App\Http\Controllers\Api\HomeApiController;
use App\Http\Controllers\Api\BrandApiController;

Route::middleware('api')->group(function () {
    Route::get('/vehicles', [VehicleApiController::class, 'index']);
    Route::get('/vehicles/{id}', [VehicleApiController::class, 'show'])->whereNumber('id');
    Route::get('/vehicles/{id}/download/{type}', [VehicleApiController::class, 'downloadDocument'])
        ->whereNumber('id')
        ->whereIn('type', ['test-drive', 'brochure']);
});

Route::middleware('api')->group(function () {
    Route::get('/categories', [CategoryApiController::class, 'index']);
});

Route::middleware('api')->group(function () {
    Route::get('/makes', [MakeApiController::class, 'index']);
});



Route::middleware('api')->group(function () {
    Route::get('/services', [ServiceApiController::class, 'index']);
});

Route::middleware('api')->group(function () {
    Route::match(['get', 'post'], '/contact', [ContactApiController::class, 'store']);
});

// Blog API Routes
Route::middleware('api')->group(function () {
    Route::apiResource('blogs', BlogApiController::class);
});


Route::middleware('api')->group(function () {
    Route::get('/images', [ImageApiController::class, 'index']);
});

Route::middleware('api')->group(function () {
    Route::get('/currency', [CurrencyApiController::class, 'showCurrent']);
});

Route::middleware('api')->group(function () {
    Route::get('/videos', [VideoApiController::class, 'index']);
});

Route::middleware('api')->group(function () {
    Route::apiResource('footer', FooterApiController::class);
});

Route::middleware('api')->group(function () {
    Route::get('/testimonials', [TestimonialApiController::class, 'index']);
});

Route::middleware('api')->group(function () {
    Route::get('/home-videos', [HomeApiController::class, 'showCurrent']);
});

Route::middleware('api')->group(function () {
    Route::get('/brands', [BrandApiController::class, 'index']);
    Route::get('/brands/{id}', [BrandApiController::class, 'show'])->whereNumber('id');
});
