<x-filament-widgets::widget class="fi-wi-recent-activity">
    <x-filament::section heading="Recent Activity">
        @if (empty($items))
            <div class="text-sm text-gray-500">No recent activity.</div>
        @else
            <div class="space-y-2">
                @foreach ($items as $item)
                    <a href="{{ $item['url'] }}" class="flex items-center justify-between gap-3 rounded-lg px-2 py-1 hover:bg-gray-50 dark:hover:bg-white/5">
                        <div class="min-w-0">
                            <div class="text-sm font-medium text-gray-900 dark:text-white">
                                {{ $item['type'] }}: {{ $item['title'] }}
                            </div>
                        </div>
                        <div class="shrink-0 text-xs text-gray-500">
                            {{ $item['at'] }}
                        </div>
                    </a>
                @endforeach
            </div>
        @endif
    </x-filament::section>
</x-filament-widgets::widget>
