<!DOCTYPE html>
<html lang="zxx">

<!-- Mirrored from html.awaikenthemes.com/Finest/dark/car-single.html by HTTrack Website Copier/3.x [XR&CO'2014], Tue, 19 Aug 2025 05:55:07 GMT -->

<head>
    <!-- Meta -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description"
        content="Finest - Your trusted dealership for premium and luxury vehicles. Find your dream car today.">
    <meta name="keywords" content="car dealership, luxury cars, buy cars, auto sales, premium vehicles">
    <meta name="author" content="Awaiken">
    <!-- Page Title -->
    <title>Finest - Premium Car Dealership</title>
    <base href="/">
    <!-- Favicon Icon -->
    <link rel="shortcut icon" type="image/x-icon" href="/images/favicon.png">
    <!-- Google Fonts Css-->
    <link rel="preconnect" href="https://fonts.googleapis.com/">
    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=DM+Sans:ital,opsz,wght@0,9..40,100..1000;1,9..40,100..1000&amp;family=Epilogue:ital,wght@0,100..900;1,100..900&amp;display=swap"
        rel="stylesheet">
    <!-- Bootstrap Css -->
    <link href="/css/bootstrap.min.css" rel="stylesheet" media="screen">
    <!-- SlickNav Css -->
    <link href="/css/slicknav.min.css" rel="stylesheet">
    <!-- Swiper Css -->
    <link rel="stylesheet" href="/css/swiper-bundle.min.css">
    <!-- Font Awesome Icon Css-->
    <link href="/css/all.css" rel="stylesheet" media="screen">
    <!-- Animated Css -->
    <link href="/css/animate.css" rel="stylesheet">
    <!-- Magnific Popup Core Css File -->
    <link rel="stylesheet" href="/css/magnific-popup.css">
    <!-- Mouse Cursor Css File -->
    <link rel="stylesheet" href="/css/mousecursor.css">
    <!-- Main Custom Css -->
    <link href="/css/custom.css" rel="stylesheet" media="screen">
    <!-- Button Custom Styles -->
    <link href="/css/button-styles.css" rel="stylesheet" media="screen">
    <!-- Flaticon Css -->
    <link rel='stylesheet'
        href='https://cdn-uicons.flaticon.com/3.0.0/uicons-regular-rounded/css/uicons-regular-rounded.css'>
    
    <!-- Car Single Page Custom Styles -->
    <style>
        /* Vehicle Header Section */
        .vehicle-header-section {
            padding: 30px 0;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            margin-bottom: 40px;
        }
        
        .breadcrumb-nav {
            display: flex;
            align-items: center;
            gap: 8px;
            margin-bottom: 15px;
            font-size: 14px;
            color: rgba(255, 255, 255, 0.6);
        }
        
        .breadcrumb-nav a {
            color: rgba(255, 255, 255, 0.6);
            text-decoration: none;
            transition: color 0.3s;
        }
        
        .breadcrumb-nav a:hover {
            color: #cfaa61;
        }
        
        .vehicle-title-row {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 15px;
        }
        
        .vehicle-title-left h1 {
            font-size: 42px;
            font-weight: 700;
            color: #fff;
            margin-bottom: 8px;
        }
        
        .vehicle-subtitle {
            font-size: 16px;
            color: rgba(255, 255, 255, 0.7);
            margin-bottom: 20px;
        }
        
        .vehicle-header-actions {
            display: flex;
            gap: 15px;
            align-items: center;
        }
        
        .header-action-btn {
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 10px 18px;
            background: transparent;
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 8px;
            color: #fff;
            text-decoration: none;
            font-size: 14px;
            transition: all 0.3s;
        }
        
        .header-action-btn:hover {
            background: rgba(207, 170, 97, 0.1);
            border-color: #cfaa61;
            color: #cfaa61;
        }
        
        .vehicle-badges {
            display: flex;
            gap: 15px;
            margin-bottom: 0;
        }
        
        .vehicle-badge {
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 10px 18px;
            background: rgba(255, 255, 255, 0.05);
            border-radius: 8px;
            font-size: 14px;
            color: #fff;
        }
        
        .vehicle-badge i {
            font-size: 18px;
            color: #cfaa61;
        }
        
        .vehicle-price-row {
            display: flex;
            justify-content: flex-end;
            align-items: center;
        }
        
        .vehicle-price-main {
            font-size: 48px;
            font-weight: 700;
            color: #fff;
        }
        
        .make-offer-btn {
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 12px 24px;
            background: #cfaa61;
            border: none;
            border-radius: 8px;
            color: #000;
            font-weight: 600;
            text-decoration: none;
            transition: all 0.3s;
        }
        
        .make-offer-btn:hover {
            background: #d4b970;
            color: #000;
        }
        
        /* Image Gallery Styles */
        .vehicle-image-gallery {
            margin-bottom: 60px;
        }
        
        .main-image-wrapper {
            position: relative;
            border-radius: 20px;
            overflow: hidden;
            height: 500px;
        }
        
        .main-vehicle-image {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        
        .featured-badge {
            position: absolute;
            top: 20px;
            left: 20px;
            background: rgba(0, 0, 0, 0.7);
            color: #fff;
            padding: 8px 20px;
            border-radius: 8px;
            font-size: 14px;
            font-weight: 600;
            text-transform: uppercase;
            z-index: 10;
        }
        
        .engine-sound-btn {
            position: absolute;
            top: 20px;
            left: 20px;
            background: #28a745;
            color: #fff;
            padding: 10px 20px;
            border: none;
            border-radius: 8px;
            font-size: 14px;
            font-weight: 600;
            text-transform: uppercase;
            z-index: 10;
            cursor: pointer;
            display: flex;
            align-items: center;
            gap: 8px;
            transition: background 0.3s ease;
        }
        
        .engine-sound-btn:hover {
            background: #218838;
        }
        
        .engine-sound-btn:active,
        .engine-sound-btn.playing {
            background: #1e7e34;
        }
        
        .engine-sound-btn i {
            font-size: 16px;
        }
        
        .thumbnail-grid-2x2 {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            grid-template-rows: repeat(2, 1fr);
            gap: 15px;
            height: 500px;
        }
        
        .thumbnail-item {
            border-radius: 15px;
            overflow: hidden;
            cursor: pointer;
            border: 3px solid transparent;
            transition: all 0.3s ease;
        }
        
        .thumbnail-item:hover {
            border-color: #cfaa61;
            transform: scale(1.02);
        }
        
        .thumbnail-item.active {
            border-color: #cfaa61;
        }
        
        .thumbnail-item img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        
        .thumbnail-item.thumbnail-fixed {
            position: relative;
            cursor: default;
            opacity: 0.95;
        }
        
        .thumbnail-item.thumbnail-fixed:hover {
            transform: none;
        }
        
        .thumbnail-badge {
            position: absolute;
            top: 8px;
            left: 8px;
            background: rgba(0, 0, 0, 0.8);
            color: #cfaa61;
            padding: 4px 10px;
            border-radius: 6px;
            font-size: 11px;
            font-weight: 600;
            text-transform: uppercase;
            z-index: 10;
            pointer-events: none;
        }
        
        /* Car Overview Section */
        .car-overview-section {
            background: transparent;
            border-radius: 20px;
            padding: 40px;
            margin-bottom: 40px;
        }
        
        .section-title-overview {
            font-size: 32px;
            font-weight: 700;
            color: #fff;
            margin-bottom: 30px;
            border-top: 3px solid rgba(255, 255, 255, 0.1);
            padding-top: 40px;
        }
        
        .overview-details-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 30px 60px;
        }
        
        .overview-item {
            display: grid;
            grid-template-columns: 30px 110px 1fr;
            gap: 20px;
            align-items: center;
            padding: 0;
            background: transparent;
            border-radius: 0;
            border: none;
        }
        
        .overview-item i {
            font-size: 20px;
            color: #cfaa61;
            flex-shrink: 0;
        }
        
        .overview-content {
            display: contents;
        }
        
        .overview-label {
            font-size: 12px;
            color: rgba(255, 255, 255, 0.6);
            margin-bottom: 0;
            font-weight: 400;
        }
        
        .overview-value {
            font-size: 14px;
            font-weight: 600;
            color: #fff;
        }
        
        /* Dealer Contact Card */
        .dealer-contact-card {
            background: transparent;
            border-radius: 15px;
            padding: 30px;
            text-align: center;
            border: 1px solid rgba(255, 255, 255, 0.05);
        }
        
        .dealer-logo {
            width: 80px;
            height: 80px;
            margin: 0 auto 15px;
            background: transparent;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 15px;
        }
        
        .dealer-logo img {
            max-width: 100%;
        }
        
        .dealer-name {
            font-size: 20px;
            font-weight: 700;
            color: #fff;
            margin-bottom: 10px;
        }
        
        .dealer-address {
            font-size: 14px;
            color: rgba(255, 255, 255, 0.6);
            margin-bottom: 20px;
            line-height: 1.6;
        }
        
        .contact-actions {
            display: flex;
            flex-direction: column;
            gap: 10px;
        }
        
        .btn-contact-action {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            padding: 12px 20px;
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 8px;
            color: #fff;
            text-decoration: none;
            transition: all 0.3s ease;
            font-size: 14px;
        }
        
        .btn-contact-action:hover {
            background: rgba(207, 170, 97, 0.1);
            border-color: #cfaa61;
            color: #cfaa61;
        }
        
        .btn-contact-whatsapp {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            padding: 14px 20px;
            background: rgba(255, 255, 255, 0.05);
            border: none;
            border-radius: 8px;
            color: #fff;
            text-decoration: none;
            transition: all 0.3s ease;
            font-weight: 600;
            font-size: 14px;
        }
        
        .btn-contact-whatsapp:hover {
            background: #20BD5A;
            color: #fff;
        }
        
        /* Features Section */
        .vehicle-features-section {
            background: transparent;
            border-radius: 20px;
            padding: 40px;
            margin-bottom: 40px;
            border-top: 3px solid rgba(255, 255, 255, 0.1);
        }
        
        .features-title {
            font-size: 32px;
            font-weight: 700;
            color: #fff;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }
        
        .features-grid {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 25px 30px;
            margin-top: 30px;
        }
        
        .feature-item {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 15px 20px;
            color: rgba(255, 255, 255, 0.9);
            font-size: 15px;
            background: rgba(255, 255, 255, 0.03);
            border-radius: 10px;
            border: 1px solid rgba(255, 255, 255, 0.05);
            transition: all 0.3s ease;
        }
        
        .feature-item:hover {
            background: rgba(255, 255, 255, 0.05);
            border-color: rgba(207, 170, 97, 0.2);
            transform: translateX(5px);
        }
        
        .feature-check {
            color: #cfaa61;
            font-size: 18px;
            flex-shrink: 0;
            font-weight: 700;
        }
        
        /* Location Section */
        .vehicle-location-section {
            background: transparent;
            border-radius: 20px;
            padding: 40px;
            margin-bottom: 40px;
            border-top: 3px solid rgba(255, 255, 255, 0.1);
        }
        
        .location-title {
            font-size: 32px;
            font-weight: 700;
            color: #fff;
            margin-bottom: 20px;
        }
        
        .location-address {
            font-size: 16px;
            color: rgba(255, 255, 255, 0.8);
            margin-bottom: 15px;
        }
        
        .get-direction-link {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            color: #cfaa61;
            text-decoration: none;
            font-size: 16px;
            font-weight: 500;
            margin-bottom: 25px;
            transition: all 0.3s;
            
            .location-map iframe {
                height: 350px;
            }
        }
        
        .get-direction-link:hover {
            color: #d4b970;
            gap: 12px;
        }
        
        .get-direction-link i {
            font-size: 20px;
        }
        
        .location-map {
            margin-top: 25px;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
        }
        
        .location-map iframe {
            display: block;
        }
        
        /* Financing Calculator Section */
        .financing-calculator-section {
            background: transparent;
            border-radius: 20px;
            padding: 40px;
            margin-bottom: 40px;
            border-top: 3px solid rgba(255, 255, 255, 0.1);
        }
        
        .calculator-title {
            font-size: 32px;
            font-weight: 700;
            color: #fff;
            margin-bottom: 30px;
        }
        
        .calculator-form .form-group {
            margin-bottom: 0;
        }
        
        .calculator-form label {
            display: block;
            font-size: 14px;
            color: rgba(255, 255, 255, 0.7);
            margin-bottom: 8px;
            font-weight: 500;
        }
        
        .calculator-form .form-control {
            width: 100%;
            padding: 15px 20px;
            background: transparent;
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 10px;
            color: #fff;
            font-size: 16px;
            transition: all 0.3s;
        }
        
        .calculator-form .form-control:focus {
            outline: none;
            border-color: #cfaa61;
            background: transparent;
        }
        
        .calculator-form .form-control::placeholder {
            color: rgba(255, 255, 255, 0.4);
        }
        
        .calculate-btn {
            display: inline-flex;
            align-items: center;
            gap: 10px;
            padding: 15px 40px;
            background: #cfaa61;
            border: none;
            border-radius: 10px;
            color: #000;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            margin-top: 25px;
        }
        
        .calculate-btn:hover {
            background: #d4b970;
            gap: 15px;
        }
        
        .calculate-btn i {
            font-size: 20px;
        }
        
        .calculation-result {
            margin-top: 30px;
            padding-top: 30px;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
        }
        
        .result-box {
            background: rgba(207, 170, 97, 0.1);
            border: 2px solid #cfaa61;
            border-radius: 15px;
            padding: 30px;
            text-align: center;
            margin-bottom: 20px;
        }
        
        .result-box h3 {
            font-size: 18px;
            color: rgba(255, 255, 255, 0.7);
            margin-bottom: 10px;
            font-weight: 500;
        }
        
        .result-amount {
            font-size: 42px;
            font-weight: 700;
            color: #cfaa61;
            margin: 0;
        }
        
        .result-details {
            display: flex;
            gap: 20px;
            justify-content: center;
        }
        
        .result-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            padding: 15px 30px;
            background: rgba(255, 255, 255, 0.03);
            border-radius: 10px;
        }
        
        .result-item span {
            font-size: 14px;
            color: rgba(255, 255, 255, 0.6);
            margin-bottom: 5px;
        }
        
        .result-item strong {
            font-size: 20px;
            color: #fff;
            font-weight: 600;
        }
        
        /* Vehicle Documents Section */
        .vehicle-documents-section {
            background: transparent;
            border-radius: 20px;
            padding: 40px;
            margin-bottom: 40px;
            border-top: 3px solid rgba(255, 255, 255, 0.1);
        }
        
        .documents-title {
            font-size: 32px;
            font-weight: 700;
            color: #fff;
            margin-bottom: 30px;
        }
        
        .documents-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 25px;
        }
        
        .document-card {
            display: flex;
            align-items: center;
            gap: 20px;
            padding: 25px;
            background: transparent;
            border: none;
            border-radius: 15px;
            transition: all 0.3s;
        }
        
        .document-card:hover {
            background: transparent;
            transform: translateY(-2px);
        }
        
        .document-icon {
            width: 60px;
            height: 60px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: rgba(207, 170, 97, 0.1);
            border-radius: 12px;
            flex-shrink: 0;
        }
        
        .document-icon i {
            font-size: 32px;
            color: #cfaa61;
        }
        
        .document-info {
            flex: 1;
        }
        
        .document-info h3 {
            font-size: 18px;
            font-weight: 600;
            color: #fff;
            margin-bottom: 5px;
        }
        
        .document-info p {
            font-size: 14px;
            color: rgba(255, 255, 255, 0.6);
            margin: 0;
        }
        
        .download-btn {
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 12px 24px;
            background: #cfaa61;
            border: none;
            border-radius: 8px;
            color: #000;
            text-decoration: none;
            font-size: 14px;
            font-weight: 600;
            transition: all 0.3s;
            white-space: nowrap;
        }
        
        .download-btn:hover {
            background: #d4b970;
            color: #000;
            gap: 12px;
        }
        
        .download-btn i {
            font-size: 16px;
        }
        
        /* Responsive */
        @media (max-width: 991px) {
            .main-image-wrapper {
                height: 400px;
                margin-bottom: 15px;
            }
            
            .thumbnail-grid-2x2 {
                height: auto;
            }
            
            .overview-details-grid {
                grid-template-columns: 1fr;
                gap: 25px;
            }
            
            .overview-item {
                display: grid;
                grid-template-columns: 30px 110px 1fr;
                gap: 12px;
                align-items: center;
            }
            
            .overview-content {
                display: contents;
            }
            
            .overview-label {
                flex-shrink: 0;
            }
            
            .overview-value {
                text-align: left;
            }
            
            .features-grid {
                grid-template-columns: repeat(2, 1fr);
                gap: 20px;
            }
        }
        
        @media (max-width: 576px) {
            .main-image-wrapper {
                height: 300px;
            }
            
            .car-overview-section {
                padding: 20px;
            }
            
            .overview-details-grid {
                gap: 35px;
            }
            
            .overview-item {
                grid-template-columns: 30px 100px 1fr;
                gap: 15px;
            }
            
            .features-grid {
                grid-template-columns: 1fr;
                gap: 15px;
            }
            
            .result-details {
                flex-direction: column;
            }
            
            .documents-grid {
                grid-template-columns: 1fr;
            }
        }
        
        /* Related Vehicles Section */
        .related-vehicles {
            padding: 80px 0;
            background: transparent;
        }
        
        .related-vehicles .fleet-single-item {
            background: linear-gradient(145deg, rgba(255, 255, 255, 0.02), rgba(255, 255, 255, 0.01));
            border: 1px solid rgba(255, 255, 255, 0.06);
            border-radius: 20px;
            overflow: hidden;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            height: 100%;
            display: flex;
            flex-direction: column;
        }
        
        .related-vehicles .fleet-single-item:hover {
            background: linear-gradient(145deg, rgba(255, 255, 255, 0.05), rgba(255, 255, 255, 0.02));
            border-color: rgba(207, 170, 97, 0.4);
            transform: translateY(-8px);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.4);
        }
        
        .related-vehicles .fleet-img {
            position: relative;
            overflow: hidden;
            height: 280px;
            background: rgba(0, 0, 0, 0.2);
        }
        
        .related-vehicles .fleet-img img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.6s cubic-bezier(0.4, 0, 0.2, 1);
        }
        
        .related-vehicles .fleet-single-item:hover .fleet-img img {
            transform: scale(1.08);
        }
        
        .related-vehicles .fleet-overlay-link {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 1;
        }
        
        .related-vehicles .fleet-content {
            padding: 30px;
            display: flex;
            flex-direction: column;
            flex-grow: 1;
        }
        
        .related-vehicles .fleet-title {
            margin-bottom: 20px;
        }
        
        .related-vehicles .fleet-title h3 {
            font-size: 24px;
            font-weight: 700;
            color: #fff;
            margin: 0;
            line-height: 1.3;
        }
        
        .related-vehicles .fleet-title h3 a {
            color: #fff;
            text-decoration: none;
            transition: color 0.3s ease;
        }
        
        .related-vehicles .fleet-title h3 a:hover {
            color: #cfaa61;
        }
        
        .related-vehicles .fleet-price {
            font-size: 14px;
            color: rgba(255, 255, 255, 0.6);
            margin-bottom: 25px;
            font-weight: 600;
            letter-spacing: 0.5px;
        }
        
        .related-vehicles .fleet-price .price-label {
            color: rgba(255, 255, 255, 0.4);
            font-weight: 400;
            font-size: 13px;
            margin-right: 8px;
        }
        
        .related-vehicles .fleet-price span {
            color: rgba(255, 255, 255, 0.4);
            font-size: 13px;
            font-weight: 400;
            margin-left: 4px;
        }
        
        .related-vehicles .btn-default {
            width: 100%;
            padding: 14px 24px;
            background: rgba(207, 170, 97, 0.08);
            border: 1.5px solid rgba(207, 170, 97, 0.25);
            color: #cfaa61;
            border-radius: 10px;
            font-weight: 600;
            font-size: 15px;
            text-align: center;
            text-decoration: none;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            display: inline-block;
            margin-top: auto;
            letter-spacing: 0.3px;
        }
        
        .related-vehicles .btn-default:hover {
            background: #cfaa61;
            color: #000;
            border-color: #cfaa61;
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(207, 170, 97, 0.3);
        }
        
        @media (max-width: 991px) {
            .related-vehicles .fleet-img {
                height: 240px;
            }
            
            .related-vehicles .fleet-content {
                padding: 25px;
            }
            
            .related-vehicles .fleet-title h3 {
                font-size: 22px;
            }
        }
        
        @media (max-width: 767px) {
            .related-vehicles {
                padding: 60px 0;
            }
            
            .related-vehicles .fleet-img {
                height: 220px;
            }
            
            .related-vehicles .fleet-content {
                padding: 20px;
            }
            
            .related-vehicles .fleet-title h3 {
                font-size: 20px;
            }
            
            .related-vehicles .btn-default {
                padding: 12px 20px;
            }
        }
    </style>
</head>

<body>

    <!-- Preloader Start -->
    <div class="preloader">
        <div class="loading-container">
            <div class="loading"></div>
            <div id="loading-icon"><img src="images/loader.svg" alt=""></div>
        </div>
    </div>
    <!-- Preloader End -->

    <!-- Header Start -->
    <header class="main-header">
        <div class="header-sticky">
            <nav class="navbar navbar-expand-lg">
                <div class="container">
                    <!-- Logo Start -->
                    <a class="navbar-brand" href="/">
                        <img src="images/logo.svg" alt="Logo">
                    </a>
                    <!-- Logo End -->

                    <!-- Main Menu Start -->
                    <div class="collapse navbar-collapse main-menu">
                        <div class="nav-menu-wrapper">
                            <ul class="navbar-nav mr-auto" id="menu">
                                <li class="nav-item"><a class="nav-link" href="/">Home</a>
                                    <!-- <ul>
                                        <li class="nav-item submenu"><a class="nav-link"
                                                href="https://html.awaikenthemes.com/Finest/light/index.html">Home -
                                                Light</a>
                                            <ul>
                                                <li class="nav-item"><a class="nav-link"
                                                        href="https://html.awaikenthemes.com/Finest/light/index.html">Home
                                                        - Background Image</a></li>
                                                <li class="nav-item"><a class="nav-link"
                                                        href="https://html.awaikenthemes.com/Finest/light/index-2.html">Home
                                                        - Background Video</a></li>
                                                <li class="nav-item"><a class="nav-link"
                                                        href="https://html.awaikenthemes.com/Finest/light/index-3.html">Home
                                                        - Background Slider</a></li>
                                            </ul>
                                        </li>
                                        <li class="nav-item submenu"><a class="nav-link" href="index-3.html">Home -
                                                Dark</a>
                                            <ul>
                                                <li class="nav-item"><a class="nav-link" href="index-3.html">Home -
                                                        Background Image</a></li>
                                                <li class="nav-item"><a class="nav-link" href="index-2.html">Home -
                                                        Background Video</a></li>
                                                <li class="nav-item"><a class="nav-link" href="index-4.html">Home -
                                                        Background Slider</a></li>
                                            </ul>
                                        </li>
                                    </ul> -->
                                </li>
                                <li class="nav-item"><a class="nav-link" href="/about">About Us</a></li>
                                <li class="nav-item"><a class="nav-link" href="/services">Services</a></li>
                                <li class="nav-item"><a class="nav-link" href="/cars">Inventory</a>
                                    <!-- <ul>
                                    <li class="nav-item"><a class="nav-link" href="/cars">Browse Inventory</a>
                                        </li>
                                        <li class="nav-item"><a class="nav-link" href="{{ route('cars') }}">Vehicle
                                                Details</a></li>
                                        <li class="nav-item"><a class="nav-link" href="{{ route('cars.category') }}">Vehicle
                                                Categories</a></li>
                                    </ul> -->
                                </li>
                                <li class="nav-item submenu"><a class="nav-link" href="javascript:void(0)">Resources</a>
                                    <ul>
                                        <!-- <li class="nav-item"><a class="nav-link" href="service-single.html">Service
                                                Details</a></li> -->
                                        <li class="nav-item"><a class="nav-link" href="/blog">Blog</a></li>
                                        <!-- <li class="nav-item"><a class="nav-link" href="blog-single.html">Blog
                                                Details</a></li> -->
                                        <!-- <li class="nav-item"><a class="nav-link" href="drivers.html">Our Team</a></li>
                                        <li class="nav-item"><a class="nav-link" href="driver-single.html">Team
                                                Member</a></li>
                                        <li class="nav-item"><a class="nav-link" href="pricing.html">Pricing</a></li> -->
                                        <li class="nav-item"><a class="nav-link" href="/image-gallery">Image
                                                Gallery</a></li>
                                        <li class="nav-item"><a class="nav-link" href="/video-gallery">Video
                                                Gallery</a></li>
                                        <!-- <li class="nav-item"><a class="nav-link"
                                                href="testimonials.html">Testimonials</a></li> -->
                                        <li class="nav-item"><a class="nav-link" href="/faqs">FAQ's</a></li>
                                        <!-- <li class="nav-item"><a class="nav-link" href="404.html">404</a></li> -->
                                    </ul>
                                </li>
                                <li class="nav-item"><a class="nav-link" href="/contact">Contact Us</a></li>
                            </ul>
                        </div>
                        <!-- Let’s Start Button Start -->
                        <!-- <div class="header-btn d-inline-flex">
                            <a href="#" class="btn-default">schedule test drive</a>
                        </div> -->
                        <!-- Let’s Start Button End -->
                    </div>
                    <!-- Main Menu End -->
                    <div class="navbar-toggle"></div>
                </div>
            </nav>
            <div class="responsive-menu"></div>
        </div>
    </header>
    <!-- Header End -->

    <!-- Page Header Start -->

    <!-- Page Header End -->

    <!-- Page Vehicle Details Start -->


    <div class="page-fleets-single">
        <div class="container">
            <!-- Vehicle Header Section -->
            <div class="vehicle-header-section">
                <!-- Title and Actions Row -->
                <div class="vehicle-title-row">
                    <div class="vehicle-title-left">
                        <h1 id="vehicle-header-title">Loading...</h1>
                        <p class="vehicle-subtitle" id="vehicle-header-subtitle">Vehicle Details</p>
                    </div>
                </div>
                
                <!-- Vehicle Badges -->
                <div class="vehicle-badges" id="vehicle-badges">
                    <div class="vehicle-badge">
                        <i class="fi fi-rr-calendar"></i>
                        <span id="badge-year">2023</span>
                    </div>
                    <div class="vehicle-badge">
                        <i class="fi fi-rr-road"></i>
                        <span id="badge-mileage">100 km</span>
                    </div>
                    <div class="vehicle-badge">
                        <i class="fi fi-rr-settings"></i>
                        <span id="badge-transmission">Automatic</span>
                    </div>
                    <div class="vehicle-badge">
                        <i class="fi fi-rr-gas-pump"></i>
                        <span id="badge-fuel">Petrol</span>
                    </div>
                </div>
                
                <!-- Price and Make Offer Row -->
                <div class="vehicle-price-row">
                    <div class="vehicle-price-main" id="vehicle-header-price">Rs: 0</div>
                </div>
            </div>
            
            <!-- Image Gallery Section -->
            <div class="row mb-5">
                <div class="col-12">
                    <div class="vehicle-image-gallery">
                        <div class="row g-3">
                            <!-- Main Featured Image -->
                            <div class="col-lg-8">
                                <div class="main-image-wrapper">
                                    <button id="engine-sound-btn" class="engine-sound-btn" style="display: none;">
                                        <i class="fas fa-volume-up"></i> Engine Sound
                                    </button>
                                    <img id="main-product-image" src="images/no-car.png" alt="Vehicle Image" class="main-vehicle-image">
                                </div>
                            </div>
                            <!-- Thumbnail Grid -->
                            <div class="col-lg-4">
                                <div class="thumbnail-grid-2x2" id="thumbnail-grid">
                                    <!-- Thumbnails will be loaded here -->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Car Overview Section -->
            <div class="row">
                <div class="col-12">
                    <div class="car-overview-section">
                        <h2 class="section-title-overview">Car Overview</h2>
                        
                        <div class="row g-4">
                            <div class="col-lg-9">
                                <div class="overview-details-grid">
                                    <!-- Left Column -->
                                    <div class="overview-item">
                                        <i class="fi fi-rr-car-side"></i>
                                        <div class="overview-content">
                                            <span class="overview-label">Body</span>
                                            <span class="overview-value" id="overview-body">-</span>
                                        </div>
                                    </div>
                                    <div class="overview-item">
                                        <i class="fi fi-rr-road"></i>
                                        <div class="overview-content">
                                            <span class="overview-label">Mileage</span>
                                            <span class="overview-value" id="overview-mileage">-</span>
                                        </div>
                                    </div>
                                    <div class="overview-item">
                                        <i class="fi fi-rr-gas-pump"></i>
                                        <div class="overview-content">
                                            <span class="overview-label">Fuel Type</span>
                                            <span class="overview-value" id="overview-fuel">-</span>
                                        </div>
                                    </div>
                                    <div class="overview-item">
                                        <i class="fi fi-rr-calendar"></i>
                                        <div class="overview-content">
                                            <span class="overview-label">Year</span>
                                            <span class="overview-value" id="overview-year">-</span>
                                        </div>
                                    </div>
                                    <div class="overview-item">
                                        <i class="fi fi-rr-settings"></i>
                                        <div class="overview-content">
                                            <span class="overview-label">Transmission</span>
                                            <span class="overview-value" id="overview-transmission">-</span>
                                        </div>
                                    </div>
                                    <div class="overview-item">
                                        <i class="fi fi-rr-steering-wheel"></i>
                                        <div class="overview-content">
                                            <span class="overview-label">Drive Type</span>
                                            <span class="overview-value" id="overview-drive-type">-</span>
                                        </div>
                                    </div>
                                    
                                    <!-- Right Column -->
                                    <div class="overview-item">
                                        <i class="fi fi-rr-info"></i>
                                        <div class="overview-content">
                                            <span class="overview-label">Condition</span>
                                            <span class="overview-value" id="overview-condition">-</span>
                                        </div>
                                    </div>
                                    <div class="overview-item">
                                        <i class="fi fi-rr-door-open"></i>
                                        <div class="overview-content">
                                            <span class="overview-label">Door</span>
                                            <span class="overview-value" id="overview-doors">-</span>
                                        </div>
                                    </div>
                                    <div class="overview-item">
                                        <i class="fi fi-rr-engine"></i>
                                        <div class="overview-content">
                                            <span class="overview-label">Cylinder</span>
                                            <span class="overview-value" id="overview-cylinder">-</span>
                                        </div>
                                    </div>
                                    <div class="overview-item">
                                        <i class="fi fi-rr-palette"></i>
                                        <div class="overview-content">
                                            <span class="overview-label">Colour</span>
                                            <span class="overview-value" id="overview-color">-</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Contact Card -->
                            <div class="col-lg-3">
                                <div class="dealer-contact-card">
                                    <div class="dealer-logo">
                                        <img src="images/logo.svg" alt="Dealer Logo">
                                    </div>
                                    <h3 class="dealer-name">Gamulanka</h3>
                                    <p class="dealer-address" id="dealer-address">184 Dutugemunu St, Colombo 10250</p>
                                    <div class="contact-actions">
                                        <a href="https://maps.app.goo.gl/saJ9MMHirH3Uqd6M6" class="btn-contact-action">
                                            <i class="fi fi-rr-marker"></i> Get Direction
                                        </a>
                                        <a href="#" class="btn-contact-action">
                                            <i class="fi fi-rr-phone-call"></i> <span id="dealer-phone">+94 777932726</span>
                                        </a>
                                        <a href="#" class="btn-contact-whatsapp">
                                            <i class="fa-brands fa-whatsapp"></i> Chat Via Whatsapp
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Features Section -->
            <div class="row">
                <div class="col-12">
                    <div class="vehicle-features-section">
                        <h2 class="features-title">Features</h2>
                        
                        <div class="features-grid" id="features-grid">
                            <!-- Features will be loaded here dynamically -->
                        </div>
                    </div>
                </div>
            </div>

            <!-- Location Section -->
            <div class="row">
                <div class="col-12">
                    <div class="vehicle-location-section">
                        <h2 class="location-title">Location</h2>
                        
                        <div class="location-address" id="location-address">
                            <p>184 Dutugemunu St, Colombo 10250</p>
                        </div>
                        
                        <a href="https://www.google.com/maps/place/Finest+Motor+Trading/@6.8685524,79.8827079,17z/data=!3m1!4b1!4m6!3m5!1s0x3ae25b318820de6d:0x1c428b0ff09638c8!8m2!3d6.8685524!4d79.8827079!16s%2Fg%2F11gsmll944?entry=ttu&g_ep=EgoyMDI2MDEwNi4wIKXMDSoASAFQAw%3D%3D" id="get-direction-link" class="get-direction-link" target="_blank">
                            Get Direction <i class="fi fi-rr-arrow-small-right"></i>
                        </a>
                        
                        <div class="location-map">
                            <iframe 
                                id="location-map-iframe"
                                width="100%" 
                                height="450" 
                                style="border:0; border-radius: 15px;" 
                                allowfullscreen="" 
                                loading="lazy" 
                                referrerpolicy="no-referrer-when-downgrade"
                                src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3960.9115738925793!2d79.88027907484746!3d6.868552393141877!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3ae25b318820de6d%3A0x1c428b0ff09638c8!2sFinest%20Motor%20Trading!5e0!3m2!1sen!2slk!4v1736439200000!5m2!1sen!2slk">
                            </iframe>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Documents Section -->
            <div class="row">
                <div class="col-12">
                    <div class="vehicle-documents-section">
                        <h2 class="documents-title">Documents & Brochures</h2>
                        
                        <div class="documents-grid">
                            <div class="document-card" id="test-drive-doc">
                                <a href="#" class="download-btn" id="test-drive-link" target="_blank">
                                    <i class="fi fi-rr-download"></i>
                               Schedule Test Drive
                                </a>
                            </div>
                            
                            <div class="document-card" id="brochure-doc">
                                <a href="#" class="download-btn" id="brochure-link" target="_blank">
                                    <i class="fi fi-rr-download"></i>
                                    Car Brochure
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Financing Calculator Section -->
            <div class="row">
                <div class="col-12">
                    <div class="financing-calculator-section">
                        <h2 class="calculator-title">Financing Calculator</h2>
                        
                        <div class="calculator-form">
                            <div class="row g-4">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="calc-price">Price (Rs)</label>
                                        <input type="number" id="calc-price" class="form-control" placeholder="3490000">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="calc-interest">Interest Rate</label>
                                        <input type="number" id="calc-interest" class="form-control" placeholder="15" step="0.1">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="calc-term">Loan Term (year)</label>
                                        <input type="number" id="calc-term" class="form-control" placeholder="7">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="calc-down">Down Payment (Rs)</label>
                                        <input type="number" id="calc-down" class="form-control" placeholder="490000">
                                    </div>
                                </div>
                            </div>
                            
                            <button type="button" id="calculate-btn" class="calculate-btn">
                                Calculate <i class="fi fi-rr-arrow-small-right"></i>
                            </button>
                            
                            <div id="calculation-result" class="calculation-result" style="display: none;">
                                <div class="result-box">
                                    <h3>Monthly Payment</h3>
                                    <p class="result-amount" id="monthly-payment">Rs 0</p>
                                </div>
                                <div class="result-details">
                                    <div class="result-item">
                                        <span>Total Amount to Pay:</span>
                                        <strong id="total-amount">Rs 0</strong>
                                    </div>
                                    <div class="result-item">
                                        <span>Total Interest:</span>
                                        <strong id="total-interest">Rs 0</strong>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Hidden Sidebar for Forms -->
            <div class="row d-none">
                <div class="col-lg-4">
                    <div id="Vehicle"></div>
                    <!-- Vehicle Details Sidebar Start -->
                    <div class="fleets-single-sidebar" style="margin-bottom: 10px;">
                        <div class="fleets-single-sidebar-box wow fadeInUp">
                            <!-- Vehicle Pricing Start -->
                            <div class="fleets-single-sidebar-pricing">
                                <h2 id="vehicle-price">Rs: 0<span>MSRP</span></h2>
                            </div>
                            <!-- Vehicle Pricing End -->

                            <!-- Vehicle Specifications List Start -->
                            <div class="fleets-single-sidebar-list">
                                <ul id="vehicle-specs">
                                    <li><i class="fi fi-rr-person-seat" style="padding-right: 10px;"></i>Seating <span
                                            id="vehicle-seating">-</span></li>
                                    <li><i class="fi fi-rr-gas-pump" style="padding-right: 10px;"></i>Fuel Type <span
                                            id="vehicle-fuel">-</span></li>
                                    <li><i class="fi fi-rr-lift" style="padding-right: 10px;"></i>Body Type <span
                                            id="vehicle-doors">-</span></li>
                                    <li><i class="fi fi-rr-road" style="padding-right: 10px;"></i>Transmission <span
                                            id="vehicle-transmission">-</span></li>
                                    <li><i class="fi fi-rr-temperature-list" style="padding-right: 10px;"></i>Climate
                                        Control <span id="vehicle-climate">-</span></li>
                                    <li><i class="fi fi-rr-road" style="padding-right: 10px;"></i>Mileage <span
                                            id="vehicle-mileage">-</span></li>
                                    <li><i class="fi fi-rr-road" style="padding-right: 10px;"></i>Registered Year <span
                                            id="vehicle-year">-</span></li>
                                    <li><i class="fi fi-rr-road" style="padding-right: 10px;"></i> Condition <span
                                            id="vehicle-condition">-</span></li>
                                    <li><i class="fi fi-rr-road" style="padding-right: 10px;"></i> Edition <span
                                            id="vehicle-edition">-</span></li>
                                </ul>
                            </div>
                            <!-- Vehicle Specifications List End -->

                            <!-- Vehicle Action Buttons Start -->
                            <div class="fleets-single-sidebar-btn" style="display: none;">
                                <!-- Request info button removed as requested -->
                            </div>
                            <!-- Purchase Options Buttons Start -->
                            <div class="payment-options-btns mt-4">
                                <div class="row">
                                    <div class="col-12 mb-3">
                                        <a href="#" class="btn-default btn-block w-100">Reserve This Vehicle</a>
                                    </div>
                                    <div class="col-12 mb-3">
                                        <a href="#" class="btn-default btn-outline w-100">
                                            <i class="fa-brands fa-whatsapp me-2"></i> Contact Sales Team
                                        </a>
                                    </div>
                                    <div class="col-12 mb-3">
                                        <a href="#" class="btn-default btn-outline w-100">
                                            <i class="fa-solid fa-calculator me-2"></i> Financing Calculator
                                        </a>
                                    </div>
                                    <div class="col-12">
                                        <button id="engineSoundBtn" class="btn-default btn-animated w-100">
                                            <i class="fa-solid fa-gauge-high"></i><span>Hold to Hear The Engine</span>
                                        </button>
                                    </div>
                                </div>
                            </div>
                            <!-- Payment Options Buttons End -->
                            <!-- Feets Single Sidebar Btn End -->
                        </div>

                        <!-- Booking Form Box Start -->
                        <div class="booking-form-box">
                            <!-- Booking PopUp Form Start -->
                            <form id="bookingform" class="white-popup-block mfp-hide booking-form">
                                <div class="section-title">
                                    <h2>Request Vehicle Information</h2>
                                    <p>Fill out the form below to receive detailed information about this vehicle. Our
                                        sales team will contact you shortly.</p>
                                </div>
                                <fieldset>
                                    <div class="row">
                                        <div class="booking-form-group col-md-6 mb-4">
                                            <input type="text" name="name" class="booking-form-control" id="name"
                                                placeholder="Full Name" required>
                                            <div class="help-block with-errors"></div>
                                        </div>

                                        <div class="booking-form-group col-md-6 mb-4">
                                            <input type="email" name="email" class="booking-form-control" id="email"
                                                placeholder="Enter Your Email" required>
                                            <div class="help-block with-errors"></div>
                                        </div>

                                        <div class="booking-form-group col-md-6 mb-4">
                                            <input type="text" name="phone" class="booking-form-control" id="phone"
                                                placeholder="Enter Your Number" required>
                                            <div class="help-block with-errors"></div>
                                        </div>

                                        <div class="booking-form-group col-md-6 mb-4">
                                            <select name="contact_preference" class="booking-form-control form-select"
                                                id="contact_preference" required>
                                                <option value="" disabled selected>Preferred Contact Method</option>
                                                <option value="phone">Phone</option>
                                                <option value="email">Email</option>
                                                <option value="text">Text Message</option>
                                            </select>
                                            <div class="help-block with-errors"></div>
                                        </div>

                                        <div class="booking-form-group col-md-6 mb-4">
                                            <select name="timeframe" class="booking-form-control form-select"
                                                id="timeframe" required>
                                                <option value="" disabled selected>Purchase Timeframe</option>
                                                <option value="immediate">Immediate (This Week)</option>
                                                <option value="soon">Soon (This Month)</option>
                                                <option value="planning">Planning (1-3 Months)</option>
                                                <option value="researching">Just Researching</option>
                                            </select>
                                            <div class="help-block with-errors"></div>
                                        </div>

                                        <div class="booking-form-group col-md-6 mb-4">
                                            <select name="trade_in" class="booking-form-control form-select"
                                                id="trade_in">
                                                <option value="" disabled selected>Trade-in Vehicle?</option>
                                                <option value="yes">Yes</option>
                                                <option value="no">No</option>
                                                <option value="unsure">Not Sure Yet</option>
                                            </select>
                                            <div class="help-block with-errors"></div>
                                        </div>

                                        <div class="booking-form-group col-md-6 mb-4">
                                            <select name="financing" class="booking-form-control form-select"
                                                id="financing">
                                                <option value="" disabled selected>Financing Needed?</option>
                                                <option value="yes">Yes</option>
                                                <option value="no">No</option>
                                                <option value="unsure">Not Sure Yet</option>
                                            </select>
                                            <div class="help-block with-errors"></div>
                                        </div>

                                        <div class="booking-form-group col-md-12 mb-4">
                                            <textarea name="msg" class="booking-form-control" id="msg" rows="3"
                                                placeholder="Write Your Message" required></textarea>
                                            <div class="help-block with-errors"></div>
                                        </div>

                                        <!-- Hidden field for vehicle ID -->
                                        <input type="hidden" name="vehicleId" id="vehicle-id" value="">

                                        <div class="col-md-12 booking-form-group">
                                            <button type="submit" class="btn-default btn-highlighted">submit
                                                request</button>
                                            <div id="msgSubmit" class="h3 hidden"></div>
                                        </div>
                                    </div>
                                </fieldset>
                            </form>
                            <!-- Booking PopUp Form End -->

                            <!-- Financing PopUp Form Start -->
                            <form id="financingform" class="white-popup-block mfp-hide booking-form">
                                <div class="section-title">
                                    <h2>Financing Options</h2>
                                    <p>Complete the form below to explore financing options for this vehicle. Our
                                        finance team will prepare a personalized quote for you.</p>
                                </div>
                                <fieldset>
                                    <div class="row">
                                        <div class="booking-form-group col-md-6 mb-4">
                                            <input type="text" name="name" class="booking-form-control"
                                                id="finance_name" placeholder="Your Name" required>
                                            <div class="help-block with-errors"></div>
                                        </div>

                                        <div class="booking-form-group col-md-6 mb-4">
                                            <input type="email" name="email" class="booking-form-control"
                                                id="finance_email" placeholder="Your Email" required>
                                            <div class="help-block with-errors"></div>
                                        </div>

                                        <div class="booking-form-group col-md-6 mb-4">
                                            <input type="tel" name="phone" class="booking-form-control"
                                                id="finance_phone" placeholder="Phone" required>
                                            <div class="help-block with-errors"></div>
                                        </div>

                                        <div class="booking-form-group col-md-6 mb-4">
                                            <select name="credit_score" class="booking-form-control form-select"
                                                id="credit_score">
                                                <option value="" disabled selected>Credit Score Range</option>
                                                <option value="excellent">Excellent (720+)</option>
                                                <option value="good">Good (690-719)</option>
                                                <option value="fair">Fair (630-689)</option>
                                                <option value="poor">Poor (Below 630)</option>
                                                <option value="unknown">I Don't Know</option>
                                            </select>
                                            <div class="help-block with-errors"></div>
                                        </div>

                                        <div class="booking-form-group col-md-6 mb-4">
                                            <select name="down_payment" class="booking-form-control form-select"
                                                id="down_payment">
                                                <option value="" disabled selected>Down Payment</option>
                                                <option value="none">Rs: 0</option>
                                                <option value="small">Rs: 1,000,000 - 3,000,000</option>
                                                <option value="medium">Rs: 3,001,000 - 5,000,000</option>
                                                <option value="large">Rs: 5,001,000 - 10,000,000</option>
                                                <option value="very_large">Rs: 10,000,000+</option>
                                            </select>
                                            <div class="help-block with-errors"></div>
                                        </div>

                                        <div class="booking-form-group col-md-6 mb-4">
                                            <select name="term_length" class="booking-form-control form-select"
                                                id="term_length">
                                                <option value="" disabled selected>Preferred Term Length</option>
                                                <option value="36">36 Months</option>
                                                <option value="48">48 Months</option>
                                                <option value="60">60 Months</option>
                                                <option value="72">72 Months</option>
                                                <option value="84">84 Months</option>
                                            </select>
                                            <div class="help-block with-errors"></div>
                                        </div>

                                        <div class="booking-form-group col-md-12 mb-4">
                                            <textarea name="message" class="booking-form-control" id="finance_message"
                                                placeholder="Additional Information" rows="3"></textarea>
                                            <div class="help-block with-errors"></div>
                                        </div>

                                        <div class="col-md-12 booking-form-group">
                                            <button type="submit" class="btn-default btn-highlighted">request financing
                                                quote</button>
                                            <div id="financeSubmit" class="h3 hidden"></div>
                                        </div>
                                    </div>
                                </fieldset>
                            </form>
                            <!-- Financing PopUp Form End -->
                        </div>
                        <!-- Booking Form Box End -->
                    </div>
                    <!-- Feets Single Sidebar End -->
                </div>

                <div class="col-lg-8">
                    <!-- Feets Single Content Start -->
                    <div class="fleets-single-content">
                        <!-- Feets Single Slider Start -->
                        <div class="fleets-single-slider">
                            <div class="swiper">
                                <div class="swiper-wrapper">
                                    <!-- Fleets Image Slide Start -->
                                    <div class="swiper-slide">
                                        <div class="fleets-slider-image">
                                            <figure class="image-anime">
                                                <img src="images/fleets-slider-img-1.jpg" alt="">
                                            </figure>
                                        </div>
                                    </div>
                                    <!-- Fleets Image Slide End -->

                                    <!-- Fleets Image Slide Start -->
                                    <div class="swiper-slide">
                                        <div class="fleets-slider-image">
                                            <figure class="image-anime">
                                                <img src="images/fleets-slider-img-1.jpg" alt="">
                                            </figure>
                                        </div>
                                    </div>
                                    <!-- Fleets Image Slide End -->

                                    <!-- Fleets Image Slide Start -->
                                    <div class="swiper-slide">
                                        <div class="fleets-slider-image">
                                            <figure class="image-anime">
                                                <img src="images/fleets-slider-img-1.jpg" alt="">
                                            </figure>
                                        </div>
                                    </div>
                                    <!-- Fleets Image Slide End -->

                                    <!-- Fleets Image Slide Start -->
                                    <div class="swiper-slide">
                                        <div class="fleets-slider-image">
                                            <figure class="image-anime">
                                                <img src="images/fleets-slider-img-1.jpg" alt="">
                                            </figure>
                                        </div>
                                    </div>
                                    <!-- Fleets Image Slide End -->
                                </div>
                                <div class="swiper-pagination"></div>
                            </div>
                        </div>
                        <!-- Feets Single Slider End -->

                        <!-- Feets Benefits Start -->
                        <div class="fleets-benefits wow fadeInUp">
                            <!-- Feets Benefits Item Start -->
                            <div class="fleets-benefits-item">
                                <div class="icon-box">
                                    <img src="images/icon-fleets-benefits-1.svg" alt="">
                                </div>
                                <div class="fleets-benefits-content">
                                    <h3>5-Year Warranty</h3>
                                    <p>Comprehensive coverage for peace of mind</p>
                                </div>
                            </div>
                            <!-- Feets Benefits Item End -->

                            <!-- Feets Benefits Item Start -->
                            <div class="fleets-benefits-item">
                                <div class="icon-box">
                                    <img src="images/icon-fleets-benefits-2.svg" alt="">
                                </div>
                                <div class="fleets-benefits-content">
                                    <h3>Free Maintenance</h3>
                                    <p>First year maintenance package included</p>
                                </div>
                            </div>
                            <!-- Feets Benefits Item End -->

                            <!-- Fleets Benefits Item Start -->
                            <div class="fleets-benefits-item">
                                <div class="icon-box">
                                    <img src="images/icon-fleets-benefits-2.svg" alt="">
                                </div>
                                <div class="fleets-benefits-content">
                                    <h3>Trade-In Options</h3>
                                    <p>We accept all makes and models</p>
                                </div>
                            </div>
                            <!-- Fleets Benefits Item End -->
                        </div>
                        <!-- Feets Benefits End -->

                        <!-- Feets Information Start -->
                        <div class="fleets-information">
                            <!-- Section Title Start -->
                            <div class="section-title">
                                <h3 class="wow fadeInUp">general information</h3>
                                <h2 class="text-anime-style-3" data-cursor="-opaque">Know about our car service</h2>
                                <p class="wow fadeInUp" data-wow-delay="0.25s">Lorem pretium fermentum quam, sit amet
                                    cursus ante sollicitudin velen morbi consesua the miss sustion consation porttitor
                                    orci sit amet iaculis nisan. Lorem pretium fermentum quam sit amet cursus ante
                                    sollicitudin velen fermen morbinetion consesua the risus consequation the porttiton.
                                </p>
                            </div>
                            <!-- Section Title End -->

                            <!-- Feets Information List Start -->
                            <div class="fleets-information-list wow fadeInUp" data-wow-delay="0.5s">
                                <ul>
                                    <li>24/7 Roadside Assistance</li>
                                    <li>Free Cancellation & Return</li>
                                    <li>Rent Now Pay When You Arrive</li>
                                </ul>
                            </div>
                            <!-- Feets Information List End -->
                        </div>
                        <!-- Feets Information End -->

                        <!-- Feets Amenities Start -->
                        <div class="fleets-amenities">
                            <!-- Section Title Start -->
                            <div class="section-title">
                                <h3 class="wow fadeInUp">amenities</h3>
                                <h2 class="text-anime-style-3" data-cursor="-opaque">Premium amenities and features</h2>
                            </div>
                            <!-- Section Title End -->

                            <!-- Feets Amenities List Start -->
                            <div class="fleets-amenities-list wow fadeInUp" data-wow-delay="0.25s">
                                <ul id="vehicle-features">
                                    <li>music system</li>
                                    <li>toolkit</li>
                                    <li>abs system</li>
                                    <li>bluetooth</li>
                                    <li>full boot space</li>
                                    <li>usb charger</li>
                                    <li>aux input</li>
                                    <li>spare tyre</li>
                                    <li>power steering</li>
                                    <li>power windows</li>
                                </ul>
                            </div>
                            <!-- Feets Amenities List End -->
                        </div>
                        <!-- Feets Amenities End -->

                        <!-- Rental Conditions Faqs Start -->
                        <!-- <div class="rental-conditions-faqs"> -->
                        <!-- Section Title Start -->
                        <!-- <div class="section-title">
                                <h3 class="wow fadeInUp">rental conditions</h3>
                                <h2 class="text-anime-style-3" data-cursor="-opaque">Policies and agreement</h2>
                            </div> -->
                        <!-- Section Title End -->

                        <!-- Rental Conditions FAQ Accordion Start -->
                        <!-- <div class="rental-condition-accordion" id="rentalaccordion"> -->
                        <!-- FAQ Item Start -->
                        <!-- <div class="accordion-item wow fadeInUp">
                                    <h2 class="accordion-header" id="rentalheading1">
                                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#rentalcollapse1" aria-expanded="true"
                                            aria-controls="rentalcollapse1">
                                            Driver's License Requirements
                                        </button>
                                    </h2>
                                    <div id="rentalcollapse1" class="accordion-collapse collapse show"
                                        aria-labelledby="rentalheading1" data-bs-parent="#rentalaccordion">
                                        <div class="accordion-body">
                                            <p>It is a long established fact that a reader will be distracted by the
                                                readable content of a page when looking at its layout. The point of
                                                using Lorem Ipsum is that it has a more-or-less normal</p>
                                        </div>
                                    </div>
                                </div> -->
                        <!-- FAQ Item End -->

                        <!-- FAQ Item Start -->
                        <!-- <div class="accordion-item wow fadeInUp" data-wow-delay="0.25s">
                                    <h2 class="accordion-header" id="rentalheading2">
                                        <button class="accordion-button collapsed" type="button"
                                            data-bs-toggle="collapse" data-bs-target="#rentalcollapse2"
                                            aria-expanded="false" aria-controls="rentalcollapse2">
                                            Insurance and Coverage policy
                                        </button>
                                    </h2>
                                    <div id="rentalcollapse2" class="accordion-collapse collapse"
                                        aria-labelledby="rentalheading2" data-bs-parent="#rentalaccordion">
                                        <div class="accordion-body">
                                            <p>It is a long established fact that a reader will be distracted by the
                                                readable content of a page when looking at its layout. The point of
                                                using Lorem Ipsum is that it has a more-or-less normal</p>
                                        </div>
                                    </div>
                                </div> -->
                        <!-- FAQ Item End -->

                        <!-- FAQ Item Start -->
                        <!-- <div class="accordion-item wow fadeInUp" data-wow-delay="0.5s">
                                    <h2 class="accordion-header" id="rentalheading3">
                                        <button class="accordion-button collapsed" type="button"
                                            data-bs-toggle="collapse" data-bs-target="#rentalcollapse3"
                                            aria-expanded="false" aria-controls="rentalcollapse3">
                                            Available payment Methods
                                        </button>
                                    </h2>
                                    <div id="rentalcollapse3" class="accordion-collapse collapse"
                                        aria-labelledby="rentalheading3" data-bs-parent="#rentalaccordion">
                                        <div class="accordion-body">
                                            <p>It is a long established fact that a reader will be distracted by the
                                                readable content of a page when looking at its layout. The point of
                                                using Lorem Ipsum is that it has a more-or-less normal</p>
                                        </div>
                                    </div>
                                </div> -->
                        <!-- FAQ Item End -->

                        <!-- FAQ Item Start -->
                        <!-- <div class="accordion-item wow fadeInUp" data-wow-delay="0.75s">
                                    <h2 class="accordion-header" id="rentalheading4">
                                        <button class="accordion-button collapsed" type="button"
                                            data-bs-toggle="collapse" data-bs-target="#rentalcollapse4"
                                            aria-expanded="false" aria-controls="rentalcollapse4">
                                            Cancellation and Modification policy
                                        </button>
                                    </h2>
                                    <div id="rentalcollapse4" class="accordion-collapse collapse"
                                        aria-labelledby="rentalheading4" data-bs-parent="#rentalaccordion">
                                        <div class="accordion-body">
                                            <p>It is a long established fact that a reader will be distracted by the
                                                readable content of a page when looking at its layout. The point of
                                                using Lorem Ipsum is that it has a more-or-less normal</p>
                                        </div>
                                    </div>
                                </div> -->
                        <!-- FAQ Item End -->

                        <!-- FAQ Item Start -->
                        <!-- <div class="accordion-item wow fadeInUp" data-wow-delay="1s">
                                    <h2 class="accordion-header" id="rentalheading5">
                                        <button class="accordion-button collapsed" type="button"
                                            data-bs-toggle="collapse" data-bs-target="#rentalcollapse5"
                                            aria-expanded="false" aria-controls="rentalcollapse5">
                                            Smoking and Pet Policies
                                        </button>
                                    </h2>
                                    <div id="rentalcollapse5" class="accordion-collapse collapse"
                                        aria-labelledby="rentalheading5" data-bs-parent="#rentalaccordion">
                                        <div class="accordion-body">
                                            <p>It is a long established fact that a reader will be distracted by the
                                                readable content of a page when looking at its layout. The point of
                                                using Lorem Ipsum is that it has a more-or-less normal</p>
                                        </div>
                                    </div>
                                </div> -->
                        <!-- FAQ Item End -->

                        <!-- FAQ Item Start -->
                        <!-- <div class="accordion-item wow fadeInUp" data-wow-delay="1.25s">
                                    <h2 class="accordion-header" id="rentalheading6">
                                        <button class="accordion-button collapsed" type="button"
                                            data-bs-toggle="collapse" data-bs-target="#rentalcollapse6"
                                            aria-expanded="false" aria-controls="rentalcollapse6">
                                            The minimum age Requirements
                                        </button>
                                    </h2>
                                    <div id="rentalcollapse6" class="accordion-collapse collapse"
                                        aria-labelledby="rentalheading6" data-bs-parent="#rentalaccordion">
                                        <div class="accordion-body">
                                            <p>It is a long established fact that a reader will be distracted by the
                                                readable content of a page when looking at its layout. The point of
                                                using Lorem Ipsum is that it has a more-or-less normal</p>
                                        </div>
                                    </div>
                                </div> -->
                        <!-- FAQ Item End -->
                        <!-- </div> -->
                        <!-- Rental Conditions FAQ Accordion End -->
                        <!-- </div> -->
                        <!-- Rental Conditions Faqs End -->
                        <!-- </div> -->
                        <!-- Feets Single Content End -->
                    </div>
                </div>
            </div>
        </div>
        <!-- Page Feets Single End -->

        <!-- Related Vehicles Section Start -->
        <section class="related-vehicles">
            <div class="container" style="padding: 60px 25px; margin-bottom: 20px;">
                <div class="row mb-60">
                    <div class="col-lg-8 mx-auto">
                        <!-- Section Title Start -->
                        <div class="section-title text-center">
                            <h2 style="color: #fff; font-size: 2.5rem; font-weight: 700; margin-bottom: 15px;">You Might Also Like</h2>
                            <p style="color: rgba(255, 255, 255, 0.8); font-size: 1.1rem;">Explore more of our premium vehicle collection</p>
                        </div>
                        <!-- Section Title End -->
                    </div>
                </div>

                <div class="row" id="related-vehicles-container">
                    <!-- Related vehicles will be loaded here via JavaScript -->
                </div>
            </div>
        </section>
        <!-- Related Vehicles Section End -->

        <!-- Footer Start -->
        @include('footer.footer')
        <!-- <footer class="main-footer bg-section">
        <div class="container">
            <div class="row">
                <div class="col-lg-3"> -->
        <!-- About Footer Start -->
        <!-- <div class="about-footer"> -->
        <!-- Footer Logo Start -->
        <!-- <div class="footer-logo">
                            <img src="images/footer-logo.svg" alt="">
                        </div> -->
        <!-- Footer Logo End -->

        <!-- About Footer Content Start -->
        <!-- <div class="about-footer-content">
                            <p>Experience the ease and convenience of renting a car with Finest. </p>
                        </div> -->
        <!-- About Footer Content End -->
        <!-- </div> -->
        <!-- About Footer End -->
        <!-- </div>

                <div class="col-lg-3 col-md-4"> -->
        <!-- Footer Quick Links Start -->
        <!-- <div class="footer-links footer-quick-links">
                        <h3>legal policy</h3>
                        <ul>
                            <li><a href="#">term & condition</a></li>
                            <li><a href="#">privacy policy</a></li>
                            <li><a href="#">legal notice</a></li>
                            <li><a href="#">accessibility</a></li>
                        </ul>
                    </div> -->
        <!-- Footer Quick Links End -->
        <!-- </div> -->

        <!-- <div class="col-lg-3 col-md-4"> -->
        <!-- Footer Menu Start -->
        <!-- <div class="footer-links footer-menu">
                        <h3>quick links</h3>
                        <ul>
                            <li><a href="#">home</a></li>
                            <li><a href="#">about us</a></li>
                            <li><a href="#">cars</a></li>
                            <li><a href="#">services</a></li>
                        </ul>
                    </div> -->
        <!-- Footer Menu End -->
        <!-- </div> -->

        <!-- <div class="col-lg-3 col-md-4"> -->
        <!-- Footer Newsletter Start -->
        <!-- <div class="footer-newsletter">
                        <h3>Subscribe to the Newsleeters</h3> -->
        <!-- Footer Newsletter Form Start -->
        <!-- <div class="footer-newsletter-form">
                            <form id="newslettersForm" action="#" method="POST">
                                <div class="form-group">
                                    <input type="email" name="email" class="form-control" id="mail"
                                        placeholder="Email ..." required>
                                    <button type="submit" class="section-icon-btn"><img src="images/arrow-white.svg"
                                            alt=""></button>
                                </div>
                            </form>
                        </div> -->
        <!-- Footer Newsletter Form End -->
        <!-- </div> -->
        <!-- Footer Newsletter End -->
        <!-- </div>
            </div> -->

        <!-- Footer Copyright Section Start -->
        <!-- <div class="footer-copyright">
                <div class="row align-items-center"> -->
        <!-- <div class="col-lg-6 col-md-7"> -->
        <!-- Footer Copyright Start -->
        <!-- <div class="footer-copyright-text">
                            <p>© 2024 Finest. All rights reserved.</p> -->
        <!-- </div> -->
        <!-- Footer Copyright End -->
        <!-- </div>

                    <div class="col-lg-6 col-md-5"> -->
        <!-- Footer Social Link Start -->
        <!-- <div class="footer-social-links">
                            <ul>
                                <li><a href="#"><i class="fa-brands fa-youtube"></i></a></li>
                                <li><a href="#"><i class="fa-brands fa-facebook-f"></i></a></li>
                                <li><a href="#"><i class="fa-brands fa-x-twitter"></i></a></li>
                                <li><a href="#"><i class="fa-brands fa-instagram"></i></a></li>
                                <li><a href="#"><i class="fa-brands fa-linkedin-in"></i></a></li>
                            </ul>
                        </div> -->
        <!-- Footer Social Link End -->
        <!-- </div>
                </div>
            </div> -->
        <!-- Footer Copyright Section End -->
        <!-- </div>
    </footer> -->
        <!-- Footer End -->

        <!-- Jquery Library File -->
        <script src="{{ asset('js/jquery-3.7.1.min.js') }}"></script>
        <!-- Jquery Ui Js File -->
        <script src="{{ asset('js/jquery-ui.js') }}"></script>
        <!-- Bootstrap js file -->
        <script src="{{ asset('js/bootstrap.min.js') }}"></script>
        <!-- Validator js file -->
        <script src="{{ asset('js/validator.min.js') }}"></script>
        <!-- SlickNav js file -->
        <script src="{{ asset('js/jquery.slicknav.js') }}"></script>
        <!-- Swiper js file -->
        <script src="{{ asset('js/swiper-bundle.min.js') }}"></script>
        <!-- Counter js file -->
        <script src="{{ asset('js/jquery.waypoints.min.js') }}"></script>
        <script src="{{ asset('js/jquery.counterup.min.js') }}"></script>
        <!-- Magnific js file -->
        <script src="{{ asset('js/jquery.magnific-popup.min.js') }}"></script>
        <!-- SmoothScroll -->
        <script src="{{ asset('js/SmoothScroll.js') }}"></script>
        <!-- Parallax js -->
        <script src="{{ asset('js/parallaxie.js') }}"></script>
        <!-- MagicCursor js file -->
        <script src="{{ asset('js/gsap.min.js') }}"></script>
        <script src="{{ asset('js/magiccursor.js') }}"></script>
        <!-- Text Effect js file -->
        <script src="{{ asset('js/SplitText.js') }}"></script>
        <script src="{{ asset('js/ScrollTrigger.min.js') }}"></script>
        <!-- YTPlayer js File -->
        <script src="{{ asset('js/jquery.mb.YTPlayer.min.js') }}"></script>
        <!-- Wow js file -->
        <script src="{{ asset('js/wow.js') }}"></script>
        <!-- Main Custom js file -->
        <script src="{{ asset('js/function.js') }}"></script>
        <!-- Engine Sound js file -->
        <script src="{{ asset('js/engine-sound.js') }}"></script>
        
        <script src="{{ asset('js/currency.js') }}"></script>
        <script src="{{ asset('js/car-single-page.js') }}"></script>
        
        <script>
        // Financing Calculator
        document.addEventListener('DOMContentLoaded', function() {
            const calculateBtn = document.getElementById('calculate-btn');
            const priceInput = document.getElementById('calc-price');
            const interestInput = document.getElementById('calc-interest');
            const termInput = document.getElementById('calc-term');
            const downInput = document.getElementById('calc-down');
            const resultDiv = document.getElementById('calculation-result');
            
            // Auto-populate from vehicle data if available
            const vehiclePrice = document.querySelector('.vehicle-price');
            if (vehiclePrice && priceInput) {
                const price = vehiclePrice.textContent.replace(/[^0-9.]/g, '');
                if (price) {
                    priceInput.value = price;
                }
            }
            
            calculateBtn.addEventListener('click', function() {
                const price = parseFloat(priceInput.value) || 0;
                const interestRate = parseFloat(interestInput.value) || 0;
                const term = parseFloat(termInput.value) || 0;
                const downPayment = parseFloat(downInput.value) || 0;
                
                if (price <= 0 || term <= 0) {
                    alert('Please enter valid values for Price and Loan Term');
                    return;
                }
                
                const loanAmount = price - downPayment;
                const monthlyRate = interestRate / 100 / 12;
                const numberOfPayments = term * 12;
                
                let monthlyPayment;
                if (interestRate === 0) {
                    monthlyPayment = loanAmount / numberOfPayments;
                } else {
                    monthlyPayment = loanAmount * (monthlyRate * Math.pow(1 + monthlyRate, numberOfPayments)) / 
                                    (Math.pow(1 + monthlyRate, numberOfPayments) - 1);
                }
                
                const totalAmount = monthlyPayment * numberOfPayments;
                const totalInterest = totalAmount - loanAmount;
                
                document.getElementById('monthly-payment').textContent = 'Rs: ' + monthlyPayment.toFixed(2);
                document.getElementById('total-amount').textContent = 'Rs: ' + totalAmount.toFixed(2);
                document.getElementById('total-interest').textContent = 'Rs: ' + totalInterest.toFixed(2);
                
                resultDiv.style.display = 'block';
            });
        });
        </script>

</body>

<!-- Mirrored from html.awaikenthemes.com/Finest/dark/car-single.html by HTTrack Website Copier/3.x [XR&CO'2014], Tue, 19 Aug 2025 05:55:09 GMT -->

</html>