const API_URL = `${window.location.origin}/api/vehicles`; // Your backend API URL

fetch(API_URL)
    .then((response) => {
        if (!response.ok)
            throw new Error(`HTTP error! status: ${response.status}`);
        return response.json();
    })
    .then(async (data) => {
        if (!data || data.length === 0) {
            console.error("No vehicles found");
            return;
        }

        const currencySymbol =
            window.Currency && window.Currency.getSymbol
                ? await window.Currency.getSymbol()
                : "Rs.";

        const currencyCode =
            window.Currency && window.Currency.getCode
                ? await window.Currency.getCode("MSRP")
                : "MSRP";

        // Use the first vehicle for display (you can change logic to select specific vehicle)
        const vehicle = data[0];

        // Sidebar details
        document.getElementById(
            "vehicle-price"
        ).innerHTML = `${currencySymbol}${vehicle.price}<span>${currencyCode}</span>`;
        document.getElementById("vehicle-seating").textContent =
            vehicle.passengers || "-";
        document.getElementById("vehicle-fuel").textContent =
            vehicle.fuel || "-";
        document.getElementById("vehicle-doors").textContent =
            vehicle.class || "-";
        document.getElementById("vehicle-transmission").textContent =
            vehicle.transmission || "-";
        document.getElementById("vehicle-climate").textContent =
            vehicle.climate_control ? "Yes" : "No";
        document.getElementById("vehicle-mileage").textContent = vehicle.mileage
            ? vehicle.mileage + " km/l"
            : "-";
        document.getElementById("vehicle-year").textContent =
            vehicle.register_year || "-";
        document.getElementById("vehicle-condition").textContent =
            vehicle.condition || "-";
        document.getElementById("vehicle-edition").textContent =
            vehicle.edition || "-";

        // Booking form hidden field
        document.getElementById("vehicle-id").value = vehicle.id;

        // Update slider images (all slides show same image here)
        const sliderImages = document.querySelectorAll(
            ".fleets-slider-image img"
        );
        sliderImages.forEach((img) => {
            img.src = vehicle.image || "images/no-car.png";
            img.alt = vehicle.name || "Vehicle Image";
        });
    })
    .catch((error) => {
        console.error("API Error:", error);
    });
