// Load testimonials from API for About page
document.addEventListener('DOMContentLoaded', function() {
    const testimonialsWrapper = document.getElementById('aboutTestimonialsWrapper') || document.querySelector('.testimonial-slider .swiper-wrapper');
    
    if (!testimonialsWrapper) {
        console.error('Testimonials wrapper not found');
        return;
    }

    // Fetch testimonials from API
    fetch('/api/testimonials')
        .then(response => response.json())
        .then(testimonials => {
            if (testimonials && testimonials.length > 0) {
                // Clear existing placeholder content
                testimonialsWrapper.innerHTML = '';
                
                // Create slides for each testimonial
                testimonials.forEach(testimonial => {
                    const slide = document.createElement('div');
                    slide.className = 'swiper-slide';
                    
                    // Generate star rating HTML
                    const rating = parseInt(testimonial.rating) || 5;
                    let starsHtml = '';
                    for (let i = 1; i <= 5; i++) {
                        if (i <= rating) {
                            starsHtml += '<i class="fa-solid fa-star"></i>';
                        } else {
                            starsHtml += '<i class="fa-regular fa-star"></i>';
                        }
                    }
                    
                    // Get image URL
                    const imageUrl = testimonial.image 
                        ? `/storage/${testimonial.image}` 
                        : '/images/author-1.jpg';
                    
                    slide.innerHTML = `
                        <div class="testimonial-item">
                            <div class="testimonial-header">
                                <div class="testimonial-rating">
                                    ${starsHtml}
                                </div>
                                <div class="testimonial-content">
                                    <p>${testimonial.review || ''}</p>
                                </div>
                            </div>
                            <div class="testimonial-body">
                                <div class="author-image">
                                    <figure class="image-anime">
                                        <img src="${imageUrl}" alt="${testimonial.name || ''}">
                                    </figure>
                                </div>
                                <div class="author-content">
                                    <h3>${testimonial.name || ''}</h3>
                                    <p>${testimonial.designation || ''}</p>
                                </div>
                            </div>
                        </div>
                    `;
                    
                    testimonialsWrapper.appendChild(slide);
                });
                
                // Reinitialize Swiper after loading content
                if (typeof Swiper !== 'undefined') {
                    const swiperContainer = document.querySelector('.testimonial-slider .swiper');
                    if (swiperContainer && swiperContainer.swiper) {
                        swiperContainer.swiper.destroy();
                    }
                    
                    new Swiper('.testimonial-slider .swiper', {
                        loop: true,
                        slidesPerView: 1,
                        spaceBetween: 30,
                        speed: 1000,
                        autoplay: {
                            delay: 5000,
                            disableOnInteraction: false,
                        },
                        breakpoints: {
                            768: {
                                slidesPerView: 2,
                            },
                            1200: {
                                slidesPerView: 3,
                            }
                        }
                    });
                }
                
                // Apply read more functionality
                applyReadMoreFunctionality();
            }
        })
        .catch(error => {
            console.error('Error loading testimonials:', error);
        });
});

// Read More Functionality
function applyReadMoreFunctionality() {
    const testimonialContents = document.querySelectorAll('.testimonial-content');
    
    testimonialContents.forEach(content => {
        const paragraph = content.querySelector('p');
        if (!paragraph) return;
        
        const text = paragraph.textContent;
        const wordCount = text.trim().split(/\s+/).length;
        
        // If text is more than 60 words, add read more functionality
        if (wordCount > 60 || paragraph.scrollHeight > 96) {
            content.classList.add('collapsed');
            
            const readMoreBtn = document.createElement('span');
            readMoreBtn.className = 'testimonial-read-more';
            readMoreBtn.textContent = 'Read more...';
            content.appendChild(readMoreBtn);
            
            readMoreBtn.addEventListener('click', function() {
                if (content.classList.contains('collapsed')) {
                    content.classList.remove('collapsed');
                    content.classList.add('expanded');
                    this.textContent = 'Read less';
                } else {
                    content.classList.add('collapsed');
                    content.classList.remove('expanded');
                    this.textContent = 'Read more...';
                }
            });
        }
    });
}
