// js/services.js

const BASE_URL = window.location.origin;
const API_URL = `${BASE_URL}/api/services`;

document.addEventListener("DOMContentLoaded", async () => {
    const wrap = document.getElementById("servicesWrap");
    if (!wrap) return;

    wrap.innerHTML = `<div class="col-12 text-center"><p>Loading services...</p></div>`;

    try {
        const res = await fetch(API_URL);
        if (!res.ok) throw new Error("API error: " + res.status);

        const services = await res.json();

        if (!Array.isArray(services) || services.length === 0) {
            wrap.innerHTML = `<div class="col-12 text-center"><p>No services found.</p></div>`;
            return;
        }

        wrap.innerHTML = "";

        services.forEach((s, i) => {
            const delay = (0.2 * i).toFixed(1);

            const icon =
                toStorageUrl(s.icon_box) || "images/icon-service-1.svg";
            const shortDesc = (s.description || "").slice(0, 80);

            wrap.insertAdjacentHTML(
                "beforeend",
                `
        <div class="col-lg-3 col-md-6">
          <div class="service-item wow fadeInUp" data-wow-delay="${delay}s">
            <div class="icon-box">
              <img src="${icon}" alt="${escapeHtml(s.title)}">
            </div>
            <div class="service-content">
              <h3>${escapeHtml(s.title)}</h3>
              <p>${escapeHtml(shortDesc)}${
                    s.description && s.description.length > 80 ? "..." : ""
                }</p>
            </div>
            <div class="service-footer">
              <a href="/services/single?id=${s.id}" class="section-icon-btn">
                <img src="images/arrow-white.svg" alt="">
              </a>
            </div>
          </div>
        </div>
        `
            );
        });

        if (typeof WOW === "function") new WOW().init();
    } catch (e) {
        console.error(e);
        wrap.innerHTML = `<div class="col-12 text-center"><p>Failed to load services.</p></div>`;
    }
});

function toStorageUrl(path) {
    if (!path) return "";
    if (path.startsWith("http://") || path.startsWith("https://")) return path;
    if (path.startsWith("/storage/")) return BASE_URL + path;
    if (path.startsWith("storage/")) return `${BASE_URL}/${path}`;
    return `${BASE_URL}/storage/${path.replace(/^\/+/, "")}`;
}

function escapeHtml(str) {
    return String(str || "")
        .replaceAll("&", "&amp;")
        .replaceAll("<", "&lt;")
        .replaceAll(">", "&gt;")
        .replaceAll('"', "&quot;")
        .replaceAll("'", "&#039;");
}
