// public/js/gallery.js

document.addEventListener("DOMContentLoaded", async () => {
    const wrap = document.getElementById("galleryWrap");
    if (!wrap) return;

    const isProbablyImageUrl = (url) => {
        if (typeof url !== "string" || !url) return false;
        if (url.includes("/storage/")) return true;
        return /\.(png|jpe?g|webp|gif|svg)(\?|#|$)/i.test(url);
    };

    try {
        const res = await fetch(`${window.location.origin}/api/images`);
        if (!res.ok) throw new Error("API error: " + res.status);

        const data = await res.json();

        wrap.innerHTML = "";

        if (!Array.isArray(data) || data.length === 0) {
            wrap.innerHTML = "<p>No images found.</p>";
            return;
        }

        data.forEach((img, i) => {
            const delay = (0.1 * (i + 1)).toFixed(1);
            const full = img.image || "";
            const thumb = isProbablyImageUrl(img.thumbnail_url)
                ? img.thumbnail_url
                : img.thumbnail || img.image || "";

            wrap.insertAdjacentHTML(
                "beforeend",
                `
        <div class="col-lg-4 col-6">
          <div class="photo-gallery wow fadeInUp" data-wow-delay="${delay}s" data-cursor-text="View">
            <a href="${full}">
              <figure class="image-anime">
                <img src="${thumb}" alt="${
                    img.title || `Gallery image ${img.id}`
                }">
              </figure>
            </a>
          </div>
        </div>
        `
            );
        });

        // Re-init WOW if you use WOW animations
        if (typeof WOW === "function") {
            new WOW().init();
        }

        // Re-init Magnific Popup (lightbox) if the plugin is loaded
        if (
            window.jQuery &&
            typeof window.jQuery.fn.magnificPopup === "function"
        ) {
            window.jQuery(".photo-gallery a").magnificPopup({
                type: "image",
                gallery: {
                    enabled: true,
                },
                mainClass: "mfp-fade",
                removalDelay: 160,
                preloader: false,
                fixedContentPos: false,
            });
        }
    } catch (e) {
        console.error("Gallery load failed:", e);
        wrap.innerHTML = "<p>Gallery failed to load.</p>";
    }
});
