// public/js/home-videos.js

const HOME_VIDEOS_API_URL = `${window.location.origin}/api/videos?limit=4`;

document.addEventListener("DOMContentLoaded", async () => {
    const wrap = document.getElementById("homeVideoCards");
    if (!wrap) return;

    const cards = Array.from(wrap.querySelectorAll(".video-card"));
    if (cards.length === 0) return;

    try {
        const res = await fetch(HOME_VIDEOS_API_URL);
        if (!res.ok) throw new Error("API error: " + res.status);

        const videos = await res.json();
        if (!Array.isArray(videos) || videos.length === 0) {
            cards.forEach((c) => (c.style.display = "none"));
            return;
        }

        cards.forEach((card, idx) => {
            const v = videos[idx];
            if (!v) {
                card.style.display = "none";
                return;
            }

            const videoUrl = v.tiktok_url || v.video || "";

            // Update video link
            const link = card.querySelector(".video-play-button a");
            if (link) {
                link.setAttribute("href", videoUrl);

                if (isLikelyVideoFileUrl(videoUrl)) {
                    link.classList.remove("popup-video");
                    link.setAttribute("target", "_blank");
                    link.setAttribute("rel", "noopener");
                } else {
                    link.classList.add("popup-video");
                    link.removeAttribute("target");
                    link.removeAttribute("rel");
                }
            }

            // Update h3 title with clickable link
            const h3Title = card.querySelector(".section-title h3");
            if (h3Title && v.title) {
                const titleLink = document.createElement("a");
                titleLink.href = videoUrl;
                titleLink.innerHTML = v.title;
                titleLink.style.cssText =
                    "color: inherit; text-decoration: none; cursor: pointer;";
                titleLink.className = "wow fadeInUp";

                if (isLikelyVideoFileUrl(videoUrl)) {
                    titleLink.setAttribute("target", "_blank");
                    titleLink.setAttribute("rel", "noopener");
                } else {
                    titleLink.classList.add("popup-video");
                }

                h3Title.innerHTML = "";
                h3Title.appendChild(titleLink);
            }

            // Update h2 subtitle with clickable link
            const sectionTitle = card.querySelector(".section-title h2");
            if (sectionTitle && v.title) {
                const titleLink = document.createElement("a");
                titleLink.href = videoUrl;
                titleLink.innerHTML = v.title;
                titleLink.style.cssText =
                    "color: inherit; text-decoration: none; cursor: pointer;";
                titleLink.setAttribute("data-cursor", "-opaque");

                if (isLikelyVideoFileUrl(videoUrl)) {
                    titleLink.setAttribute("target", "_blank");
                    titleLink.setAttribute("rel", "noopener");
                } else {
                    titleLink.classList.add("popup-video");
                }

                // Replace text with link
                sectionTitle.innerHTML = "";
                sectionTitle.appendChild(titleLink);
            }

            if (v.thumbnail) {
                card.style.backgroundImage = `url('${escapeCssUrl(
                    v.thumbnail
                )}')`;
            }
        });

        // Re-bind Magnific Popup in case it was initialized before
        if (
            window.jQuery &&
            window.jQuery.fn &&
            window.jQuery.fn.magnificPopup
        ) {
            window.jQuery(wrap).find(".popup-video").magnificPopup({
                type: "iframe",
                mainClass: "mfp-fade",
                removalDelay: 160,
                preloader: false,
                fixedContentPos: true,
            });
        }
    } catch (err) {
        console.error("Home videos load failed:", err);
    }
});

function isLikelyVideoFileUrl(url) {
    if (!url) return false;
    const clean = String(url).split("?")[0].toLowerCase();
    return (
        clean.endsWith(".mp4") ||
        clean.endsWith(".webm") ||
        clean.endsWith(".mov") ||
        clean.endsWith(".m4v")
    );
}

function escapeCssUrl(url) {
    return String(url).replaceAll("'", "\\'");
}
