// Fetch hero content immediately (not waiting for DOMContentLoaded)
(function() {
    const apiUrl = `${window.location.origin}/api/home-videos`;
    
    function updateHeroContent() {
        fetch(apiUrl)
            .then((response) => response.json())
            .then((result) => {
                if (result.status !== "success" || !result.data) return;

                const data = result.data;

                // Update text content immediately
                const heroTitle = document.getElementById("heroTitle");
                const heroSubtitle = document.getElementById("heroSubtitle");
                const heroDescription = document.getElementById("heroDescription");
                const heroButton = document.getElementById("heroButton");

                if (heroTitle) {
                    heroTitle.textContent = data.title ?? "";
                    heroTitle.style.opacity = "1";
                    heroTitle.style.visibility = "visible";
                }
                if (heroSubtitle) {
                    heroSubtitle.textContent = data.subtitle ?? "";
                    heroSubtitle.style.opacity = "1";
                    heroSubtitle.style.visibility = "visible";
                }
                if (heroDescription) {
                    heroDescription.textContent = data.description ?? "";
                    heroDescription.style.opacity = "1";
                    heroDescription.style.visibility = "visible";
                }
                if (heroButton) {
                    heroButton.textContent = data.button_name ?? "";
                    heroButton.style.opacity = "1";
                    heroButton.style.visibility = "visible";
                }

                // Check if image is active (handle both boolean and integer values)
                const isImageActive = data.is_image_active === true || data.is_image_active === 1 || data.is_image_active === "1";
                
                if (isImageActive && data.image) {
                    console.log("Image mode active, loading image:", data.image);
                    
                    // Hide video and show image
                    const videoElement = document.getElementById("myVideo");
                    const heroSection = document.querySelector(".hero-section.hero-video");
                    
                    if (videoElement) {
                        videoElement.style.display = "none";
                        console.log("Video hidden");
                    }
                    
                    if (heroSection) {
                        const imageUrl = data.image.startsWith("http")
                            ? data.image
                            : `/storage/${data.image}`;
                        
                        console.log("Setting background image URL:", imageUrl);
                        
                        heroSection.style.backgroundImage = `url('${imageUrl}')`;
                        heroSection.style.backgroundSize = "cover";
                        heroSection.style.backgroundPosition = "center";
                        heroSection.style.backgroundRepeat = "no-repeat";
                        heroSection.style.height = "750px";
                        // Remove the video background container
                        const videoBgDiv = document.querySelector(".hero-bg-video");
                        if (videoBgDiv) {
                            videoBgDiv.style.display = "none";
                        }
                    }
                } else if (data.video) {
                    console.log("Video mode active, loading video:", data.video);
                    
                    // Show video (default behavior)
                    const videoSource = document.getElementById("heroVideoSource");
                    const videoElement = document.getElementById("myVideo");
                    const heroSection = document.querySelector(".hero-section.hero-video");

                    // Reset background image if it was set
                    if (heroSection) {
                        heroSection.style.backgroundImage = "none";
                    }
                    
                    // Show video background container
                    const videoBgDiv = document.querySelector(".hero-bg-video");
                    if (videoBgDiv) {
                        videoBgDiv.style.display = "block";
                    }

                    if (videoSource && videoElement) {
                        videoElement.style.display = "block";
                        
                        // Construct the full video URL
                        const videoUrl = data.video.startsWith("http")
                            ? data.video
                            : `/storage/${data.video}`;

                        videoSource.src = videoUrl;
                        videoElement.load();

                        // Force video height
                        videoElement.style.height = "750px";

                        // Ensure autoplay after loading
                        videoElement.play().catch((error) => {
                            console.log("Autoplay prevented:", error);
                        });
                    }
                }
            })
            .catch((error) => {
                console.error("Home video API error:", error);
            });
    }
    
    // Execute immediately
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', updateHeroContent);
    } else {
        updateHeroContent();
    }
})();
