document.addEventListener("DOMContentLoaded", () => {
    const API_BASE = window.location.origin;
    const container = document.getElementById("home-categories");

    if (!container) return;

    // Use cached data if available
    if (window.HOMEPAGE_DATA && window.HOMEPAGE_DATA.loaded && window.HOMEPAGE_DATA.categories.length > 0) {
        renderCategories(window.HOMEPAGE_DATA.categories, container, API_BASE);
        return;
    }

    fetch(`${API_BASE}/api/categories`)
        .then((response) => {
            if (!response.ok)
                throw new Error(`HTTP error! status: ${response.status}`);
            return response.json();
        })
        .then((categories) => {
            renderCategories(categories, container, API_BASE);
        })
        .catch((err) => console.error("Error loading categories:", err));
});

function renderCategories(categories, container, API_BASE) {
    if (!Array.isArray(categories) || categories.length === 0) {
        return; // keep the static fallback HTML
    }

    const items = categories.slice(0, 4);
    container.innerHTML = "";

    items.forEach((cat, index) => {
        const delay =
            index === 0
                ? ""
                : ` data-wow-delay="${(index * 0.25).toFixed(2)}s"`;
        const imageUrl =
            cat.image_url ||
            `${API_BASE}/storage/${String(cat.image || "")
                .replace(/^storage\//, "")
                .replace(/^\/+/, "")}`;

        container.insertAdjacentHTML(
            "beforeend",
            `
          <div class="luxury-collection-item wow fadeInUp"${delay}>
            <div class="luxury-collection-image" data-cursor-text="View">
              <a href="/cars/category">
                <figure>
                  <img src="${imageUrl}" alt="${cat.name || "Category"}">
                </figure>
              </a>
            </div>

            <div class="luxury-collection-title">
              <h2>${cat.name || "category"}</h2>
            </div>

            <div class="luxury-collection-btn">
              <a href="/cars/category" class="section-icon-btn"><img src="images/arrow-white.svg" alt=""></a>
            </div>
          </div>
          `
                );
            });

            if (typeof WOW !== "undefined") {
                new WOW().init();
            }
        })
        .catch((error) => {
            console.error("API Error (categories):", error);
            // keep the static fallback HTML
        });
}
