// footer.js
// Loads footer data from Laravel API and connects links in the Blade footer.

async function loadFooterFromApi() {
    try {
        const response = await fetch("/api/footer", {
            headers: {
                Accept: "application/json",
            },
        });

        if (!response.ok) {
            return;
        }

        const footer = await response.json();
        if (!footer || typeof footer !== "object") {
            return;
        }

        const links = {
            "footer-link-youtube": footer.youtube_url,
            "footer-link-facebook": footer.facebook_url,
            "footer-link-twitter": footer.twitter_url,
            "footer-link-instagram": footer.instagram_url,
            "footer-link-linkedin": footer.linkedin_url,
        };

        Object.entries(links).forEach(([id, url]) => {
            const el = document.getElementById(id);
            if (!el) return;
            if (typeof url === "string" && url.trim().length > 0) {
                el.setAttribute("href", url.trim());
            }
        });
    } catch (error) {
        console.error("Error loading footer from API:", error);
    }
}

if (document.readyState === "loading") {
    document.addEventListener("DOMContentLoaded", loadFooterFromApi);
} else {
    loadFooterFromApi();
}
