// Fast parallel loader for all homepage content
(function() {
    'use strict';
    
    const API_BASE = window.location.origin;
    
    // Fetch all data in parallel immediately
    const dataPromises = {
        vehicles: fetch(`${API_BASE}/api/vehicles?featured=true&limit=6`).then(r => r.ok ? r.json() : []).catch(() => []),
        allVehicles: fetch(`${API_BASE}/api/vehicles`).then(r => r.ok ? r.json() : []).catch(() => []),
        testimonials: fetch(`${API_BASE}/api/testimonials`).then(r => r.ok ? r.json() : []).catch(() => []),
        blogs: fetch(`${API_BASE}/api/blogs`).then(r => r.ok ? r.json() : []).catch(() => []),
        videos: fetch(`${API_BASE}/api/videos?limit=4`).then(r => r.ok ? r.json() : []).catch(() => []),
        categories: fetch(`${API_BASE}/api/categories`).then(r => r.ok ? r.json() : []).catch(() => []),
        makes: fetch(`${API_BASE}/api/makes`).then(r => r.ok ? r.json() : []).catch(() => [])
    };
    
    // Store loaded data globally for other scripts to use
    window.HOMEPAGE_DATA = {
        loaded: false,
        vehicles: [],
        allVehicles: [],
        testimonials: [],
        blogs: [],
        videos: [],
        categories: [],
        makes: []
    };
    
    // Load all data in parallel
    Promise.all([
        dataPromises.vehicles,
        dataPromises.allVehicles,
        dataPromises.testimonials,
        dataPromises.blogs,
        dataPromises.videos,
        dataPromises.categories,
        dataPromises.makes
    ]).then(([vehicles, allVehicles, testimonials, blogs, videos, categories, makes]) => {
        window.HOMEPAGE_DATA = {
            loaded: true,
            vehicles: vehicles || [],
            allVehicles: allVehicles || [],
            testimonials: testimonials || [],
            blogs: Array.isArray(blogs) ? blogs : (blogs?.data || []),
            videos: videos || [],
            categories: categories || [],
            makes: makes || []
        };
        
        // Trigger custom event that data is ready
        document.dispatchEvent(new CustomEvent('homepageDataReady', {
            detail: window.HOMEPAGE_DATA
        }));
        
        console.log('✅ All homepage data loaded:', window.HOMEPAGE_DATA);
    }).catch(err => {
        console.error('Error loading homepage data:', err);
        window.HOMEPAGE_DATA.loaded = true;
        document.dispatchEvent(new CustomEvent('homepageDataReady', {
            detail: window.HOMEPAGE_DATA
        }));
    });
})();
