/**
 * Engine Sound Player Script
 * This script handles the functionality for the "Hold to Hear The Engine" button
 */

document.addEventListener('DOMContentLoaded', function() {
    // Get the engine sound button element
    const engineSoundBtn = document.getElementById('engineSoundBtn');
    
    // Create audio element for engine sound
    const engineSound = new Audio();
    const defaultSrc = 'audio/engine-sound.mp3';
    engineSound.src = defaultSrc; // Fallback sound
    engineSound.loop = true;
    
    // Add event listeners for mouse/touch interactions
    if (engineSoundBtn) {
        // Mouse events
        engineSoundBtn.addEventListener('mousedown', startSound);
        engineSoundBtn.addEventListener('mouseup', stopSound);
        engineSoundBtn.addEventListener('mouseleave', stopSound);
        
        // Touch events for mobile
        engineSoundBtn.addEventListener('touchstart', function(e) {
            e.preventDefault(); // Prevent default touch behavior
            startSound();
        });
        engineSoundBtn.addEventListener('touchend', function(e) {
            e.preventDefault(); // Prevent default touch behavior
            stopSound();
        });
    }
    
    // Function to start playing the engine sound
    function startSound() {
        engineSoundBtn.classList.add('active');
        // Allow per-vehicle sound (set by page script)
        const dynamicSrc = engineSoundBtn?.dataset?.soundUrl;
        const nextSrc = dynamicSrc || defaultSrc;
        if (engineSound.src !== nextSrc) {
            engineSound.src = nextSrc;
            engineSound.load();
        }
        engineSound.currentTime = 0; // Reset to beginning
        engineSound.play().catch(error => {
            console.error('Error playing engine sound:', error);
        });
    }
    
    // Function to stop playing the engine sound
    function stopSound() {
        engineSoundBtn.classList.remove('active');
        engineSound.pause();
    }
});