// contact-social.js
// Loads social media links from footer API for contact page

(async function loadContactSocialLinks() {
    try {
        const response = await fetch("/api/footer", {
            headers: {
                Accept: "application/json",
            },
        });

        if (!response.ok) {
            return;
        }

        const footer = await response.json();
        if (!footer || typeof footer !== "object") {
            return;
        }

        // Map the contact page social link IDs to footer API data
        const links = {
            "contact-link-facebook": footer.facebook_url,
            "contact-link-instagram": footer.instagram_url,
            "contact-link-tiktok": footer.tiktok_url,
        };

        // Update each link with the API URL
        Object.entries(links).forEach(([id, url]) => {
            const el = document.getElementById(id);
            if (!el) return;
            if (typeof url === "string" && url.trim().length > 0) {
                el.setAttribute("href", url.trim());
            }
        });

        // Also load contact info (phone, email, address)
        const contactPhone = document.getElementById("contact-phone");
        const contactEmail = document.getElementById("contact-email");
        const contactAddress = document.getElementById("contact-address");

        if (contactPhone && footer.phone) {
            contactPhone.textContent = footer.phone;
        }
        if (contactEmail && footer.email) {
            contactEmail.textContent = footer.email;
        }
        if (contactAddress && footer.address) {
            contactAddress.textContent = footer.address;
        }

    } catch (error) {
        console.error("Error loading contact social links from API:", error);
    }
})();
