// contact-info.js
// Loads contact information from Footer API

(function() {
    'use strict';
    
    async function loadContactInfo() {
        try {
            const response = await fetch('/api/footer', {
                headers: {
                    'Accept': 'application/json',
                },
            });

            if (!response.ok) {
                console.warn('Failed to fetch contact info');
                return;
            }

            const data = await response.json();
            
            if (!data || typeof data !== 'object') {
                return;
            }

            // Update phone
            const phoneEl = document.getElementById('contact-phone');
            if (phoneEl && data.phone) {
                phoneEl.textContent = data.phone;
            }

            // Update email
            const emailEl = document.getElementById('contact-email');
            if (emailEl && data.email) {
                emailEl.textContent = data.email;
            }

            // Update address
            const addressEl = document.getElementById('contact-address');
            if (addressEl && data.address) {
                addressEl.textContent = data.address;
            }

        } catch (error) {
            console.error('Error loading contact info:', error);
        }
    }

    // Execute immediately
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', loadContactInfo);
    } else {
        loadContactInfo();
    }
})();
