document.addEventListener("DOMContentLoaded", () => {
    const API_BASE = window.location.origin;
    const container = document.getElementById("categoryContainer");

    if (!container) return;

    fetch(`${API_BASE}/api/categories`)
        .then((response) => {
            if (!response.ok) throw new Error(`HTTP ${response.status}`);
            return response.json();
        })
        .then((result) => {
            const list = Array.isArray(result) ? result : [];

            if (list.length === 0) {
                container.innerHTML = "<p>No categories found</p>";
                return;
            }

            container.innerHTML = "";

            list.forEach((item, index) => {
                const delay = (index * 0.25).toFixed(2);
                const imageUrl =
                    item.image_url ||
                    `${API_BASE}/storage/${String(item.image || "")
                        .replace(/^storage\//, "")
                        .replace(/^\/+/, "")}`;

                const html = `
                <div class="col-lg-4 col-md-6">
                    <div class="luxury-collection-item luxury-car-type wow fadeInUp" data-wow-delay="${delay}s">

                        <div class="luxury-collection-image" data-cursor-text="View">
                            <a href="/cars?category_id=${item.id}">
                                <figure>
                                    <img src="${imageUrl}" alt="${item.name}">
                                </figure>
                            </a>
                        </div>

                        <div class="luxury-collection-title">
                            <h2>${item.name}</h2>
                        </div>

                        <div class="luxury-collection-btn">
                            <a href="/cars?category_id=${item.id}" class="section-icon-btn">
                                <img src="images/arrow-white.svg" alt="">
                            </a>
                        </div>

                    </div>
                </div>
                `;

                container.insertAdjacentHTML("beforeend", html);
            });
        })
        .catch((error) => {
            console.error("API Error:", error);
            container.innerHTML = "<p>Failed to load categories</p>";
        });
});
