document.addEventListener("DOMContentLoaded", function () {
    const BLOG_API_URL = `${window.location.origin}/api/blogs`;

    async function loadBlogs() {
        const response = await fetch(BLOG_API_URL);
        const result = await response.json();

        console.log("API Response:", result);

        const container = document.getElementById("blog-container");
        if (!container) {
            console.error("Blog container not found");
            return;
        }

        container.innerHTML = "";

        let displayIndex = 0;
        if (!result.data || result.data.length === 0) {
            console.warn("No blogs found in API response");
            container.innerHTML = "<p>No blogs available</p>";
            return;
        }

        result.data.forEach((blog) => {
            const imageUrl =
                blog.image_url || blog.image || "images/no-blog.png";
            console.log(`Loading blog ${blog.id}: image = ${imageUrl}`);

            const date = new Date(blog.date).toLocaleDateString("en-US", {
                year: "numeric",
                month: "long",
                day: "numeric",
            });

            container.innerHTML += `
                <div class="col-lg-4 col-md-6">
                    <div class="post-item wow fadeInUp" data-wow-delay="${
                        displayIndex * 0.25
                    }s">
                        <div class="post-featured-image" data-cursor-text="View">
                            <figure style="margin: 0;">
                                <a href="/blog/single?id=${
                                    blog.id
                                }" class="image-anime">
                                    <img src="${imageUrl}" alt="${blog.title}">
                                </a>
                            </figure>
                        </div>

                        <div class="post-item-body">
                            <div class="post-meta">
                                <ul>
                                    <li>
                                        <a href="#"><i class="fa-solid fa-calendar-days"></i> ${date}</a>
                                    </li>
                                </ul>
                            </div>

                            <div class="post-item-content">
                                <h2>
                                    <a href="/blog/single?id=${blog.id}">${
                blog.title
            }</a>
                                </h2>
                            </div>

                            <div class="post-item-btn">
                                <a href="/blog/single?id=${
                                    blog.id
                                }" class="read-story-btn">read more</a>
                            </div>
                        </div>
                    </div>
                </div>
            `;
            displayIndex++;
        });
    }

    loadBlogs();
});
