<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('home_videos', function (Blueprint $table) {
            $table->string('image')->nullable()->after('video');
            $table->boolean('is_image_active')->default(false)->after('image');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('home_videos', function (Blueprint $table) {
            $table->dropColumn(['image', 'is_image_active']);
        });
    }
};
