<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('vehicles', function (Blueprint $table) {
            $table->string('colour')->nullable()->after('name');
            $table->decimal('discount', 5, 2)->nullable()->after('price');
            $table->integer('cylinder')->nullable()->after('cc');
            $table->string('drive_type')->nullable()->after('transmission');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vehicles', function (Blueprint $table) {
            $table->dropColumn(['colour', 'discount', 'cylinder', 'drive_type']);
        });
    }
};
