<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('vehicles', function (Blueprint $table) {
            $table->string('schedule_test_drive_pdf')->nullable()->after('sound');
            $table->string('car_brochure_pdf')->nullable()->after('schedule_test_drive_pdf');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vehicles', function (Blueprint $table) {
            $table->dropColumn(['schedule_test_drive_pdf', 'car_brochure_pdf']);
        });
    }
};
