<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('vehicles', function (Blueprint $table) {
            if (!Schema::hasColumn('vehicles', 'is_featured')) {
                $table->boolean('is_featured')->default(false)->after('make_id');
            }
            if (!Schema::hasColumn('vehicles', 'is_popular')) {
                $table->boolean('is_popular')->default(false)->after('is_featured');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vehicles', function (Blueprint $table) {
            if (Schema::hasColumn('vehicles', 'is_featured')) {
                $table->dropColumn('is_featured');
            }
            if (Schema::hasColumn('vehicles', 'is_popular')) {
                $table->dropColumn('is_popular');
            }
        });
    }
};
