<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('testimonials', function (Blueprint $table) {
            if (! Schema::hasColumn('testimonials', 'name')) {
                $table->string('name');
            }

            if (! Schema::hasColumn('testimonials', 'designation')) {
                $table->string('designation')->nullable();
            }

            if (! Schema::hasColumn('testimonials', 'review')) {
                $table->text('review');
            }

            if (! Schema::hasColumn('testimonials', 'rating')) {
                $table->unsignedTinyInteger('rating');
            }

            if (! Schema::hasColumn('testimonials', 'image')) {
                $table->string('image')->nullable();
            }

            if (! Schema::hasColumn('testimonials', 'status')) {
                $table->boolean('status')->default(1);
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('testimonials', function (Blueprint $table) {
            if (Schema::hasColumn('testimonials', 'status')) {
                $table->dropColumn('status');
            }
            if (Schema::hasColumn('testimonials', 'image')) {
                $table->dropColumn('image');
            }
            if (Schema::hasColumn('testimonials', 'rating')) {
                $table->dropColumn('rating');
            }
            if (Schema::hasColumn('testimonials', 'review')) {
                $table->dropColumn('review');
            }
            if (Schema::hasColumn('testimonials', 'designation')) {
                $table->dropColumn('designation');
            }
            if (Schema::hasColumn('testimonials', 'name')) {
                $table->dropColumn('name');
            }
        });
    }
};
