<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('services', function (Blueprint $table) {
            if (Schema::hasColumn('services', 'description')) {
                $table->dropColumn('description');
            }
            if (Schema::hasColumn('services', 'title')) {
                $table->dropColumn('title');
            }
            if (Schema::hasColumn('services', 'icon')) {
                $table->dropColumn('icon');
            }
            if (Schema::hasColumn('services', 'icon_box')) {
                $table->dropColumn('icon_box');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('services', function (Blueprint $table) {
            $table->string('title')->nullable();
            $table->text('description')->nullable();
            $table->string('icon')->nullable();
            $table->string('icon_box')->nullable();
        });
    }
};
