<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (! Schema::hasTable('blogs')) {
            return;
        }

        $columns = [
            'facebook_url',
            'youtube_url',
            'instagram_url',
            'twitter_url',
        ];

        $driver = Schema::getConnection()->getDriverName();

        foreach ($columns as $column) {
            if (! Schema::hasColumn('blogs', $column)) {
                continue;
            }

            if ($driver === 'mysql') {
                DB::statement("ALTER TABLE `blogs` MODIFY `{$column}` TEXT NULL");
            } elseif ($driver === 'pgsql') {
                DB::statement("ALTER TABLE blogs ALTER COLUMN {$column} TYPE TEXT");
                DB::statement("ALTER TABLE blogs ALTER COLUMN {$column} DROP NOT NULL");
            }
        }
    }

    public function down(): void
    {
        if (! Schema::hasTable('blogs')) {
            return;
        }

        $columns = [
            'facebook_url',
            'youtube_url',
            'instagram_url',
            'twitter_url',
        ];

        $driver = Schema::getConnection()->getDriverName();

        foreach ($columns as $column) {
            if (! Schema::hasColumn('blogs', $column)) {
                continue;
            }

            if ($driver === 'mysql') {
                DB::statement("ALTER TABLE `blogs` MODIFY `{$column}` VARCHAR(255) NULL");
            } elseif ($driver === 'pgsql') {
                DB::statement("ALTER TABLE blogs ALTER COLUMN {$column} TYPE VARCHAR(255)");
                DB::statement("ALTER TABLE blogs ALTER COLUMN {$column} DROP NOT NULL");
            }
        }
    }
};
