<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (! Schema::hasTable('vehicles') || ! Schema::hasColumn('vehicles', 'edition')) {
            return;
        }

        // Avoid requiring doctrine/dbal by using raw SQL for MySQL.
        DB::statement('ALTER TABLE `vehicles` MODIFY `edition` VARCHAR(255) NULL');
    }

    public function down(): void
    {
        if (! Schema::hasTable('vehicles') || ! Schema::hasColumn('vehicles', 'edition')) {
            return;
        }

        // Best-effort rollback: set NOT NULL with empty-string default.
        DB::statement("ALTER TABLE `vehicles` MODIFY `edition` VARCHAR(255) NOT NULL DEFAULT ''");
    }
};
