<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('imagegalleries', function (Blueprint $table) {
            $table->string('thumbnail')->nullable()->after('image');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('imagegalleries', 'thumbnail')) {
            Schema::table('imagegalleries', function (Blueprint $table) {
                $table->dropColumn('thumbnail');
            });
        }
    }
};
