<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('blogs')) {
            return;
        }

        $hasFacebook = Schema::hasColumn('blogs', 'facebook_url');
        $hasYoutube = Schema::hasColumn('blogs', 'youtube_url');
        $hasInstagram = Schema::hasColumn('blogs', 'instagram_url');
        $hasTwitter = Schema::hasColumn('blogs', 'twitter_url');

        if ($hasFacebook && $hasYoutube && $hasInstagram && $hasTwitter) {
            return;
        }

        Schema::table('blogs', function (Blueprint $table) use ($hasFacebook, $hasYoutube, $hasInstagram, $hasTwitter) {
            if (!$hasFacebook) {
                $table->string('facebook_url')->nullable()->after('tags');
            }

            if (!$hasYoutube) {
                $table->string('youtube_url')->nullable()->after('facebook_url');
            }

            if (!$hasInstagram) {
                $table->string('instagram_url')->nullable()->after('youtube_url');
            }

            if (!$hasTwitter) {
                $table->string('twitter_url')->nullable()->after('instagram_url');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (!Schema::hasTable('blogs')) {
            return;
        }

        $hasFacebook = Schema::hasColumn('blogs', 'facebook_url');
        $hasYoutube = Schema::hasColumn('blogs', 'youtube_url');
        $hasInstagram = Schema::hasColumn('blogs', 'instagram_url');
        $hasTwitter = Schema::hasColumn('blogs', 'twitter_url');

        if (!$hasFacebook && !$hasYoutube && !$hasInstagram && !$hasTwitter) {
            return;
        }

        Schema::table('blogs', function (Blueprint $table) use ($hasFacebook, $hasYoutube, $hasInstagram, $hasTwitter) {
            $drop = [];

            if ($hasFacebook) {
                $drop[] = 'facebook_url';
            }
            if ($hasYoutube) {
                $drop[] = 'youtube_url';
            }
            if ($hasInstagram) {
                $drop[] = 'instagram_url';
            }
            if ($hasTwitter) {
                $drop[] = 'twitter_url';
            }

            if ($drop !== []) {
                $table->dropColumn($drop);
            }
        });
    }
};
