<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (Schema::hasTable('blogs')) {
            return;
        }

        Schema::create('blogs', function (Blueprint $table) {
            $table->id();
            $table->string('image')->nullable();
            $table->date('date');
            $table->string('title');
            $table->string('tags')->nullable();
            $table->string('facebook_url')->nullable()->after('tags');
            $table->string('youtube_url')->nullable()->after('facebook_url');
            $table->string('instagram_url')->nullable()->after('youtube_url');
            $table->string('twitter_url')->nullable()->after('instagram_url');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('blogs', function (Blueprint $table) {
            $table->dropColumn([
                'facebook_url',
                'youtube_url',
                'instagram_url',
                'twitter_url',
            ]);
        });
    }
};
