<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('vehicles', function (Blueprint $table) {
            if (!Schema::hasColumn('vehicles', 'body_type')) {
                $table->string('body_type')->nullable()->after('price');
            }
            if (!Schema::hasColumn('vehicles', 'transmission')) {
                $table->string('transmission')->nullable()->after('body_type');
            }
            if (!Schema::hasColumn('vehicles', 'climate_control')) {
                $table->boolean('climate_control')->default(false)->after('transmission');
            }
            if (!Schema::hasColumn('vehicles', 'mileage')) {
                $table->decimal('mileage', 8, 2)->nullable()->after('climate_control');
            }
            if (!Schema::hasColumn('vehicles', 'register_year')) {
                $table->integer('register_year')->nullable()->after('mileage');
            }
            if (!Schema::hasColumn('vehicles', 'condition')) {
                $table->string('condition')->nullable()->after('register_year');
            }
            if (!Schema::hasColumn('vehicles', 'edition')) {
                $table->string('edition')->nullable()->after('condition');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vehicles', function (Blueprint $table) {
            $table->dropColumn([
                'body_type',
                'transmission',
                'climate_control',
                'mileage',
                'register_year',
                'condition',
                'edition',
                'make',
            ]);
        });
    }
};
