<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('vehicles', function (Blueprint $table) {
            if (Schema::hasColumn('vehicles', 'passangers')) {
                $table->renameColumn('passangers', 'passengers');
            }
            if (Schema::hasColumn('vehicles', 'Cc')) {
                $table->renameColumn('Cc', 'cc');
            }
        });
    }

    public function down(): void
    {
        Schema::table('vehicles', function (Blueprint $table) {
            if (Schema::hasColumn('vehicles', 'passengers')) {
                $table->renameColumn('passengers', 'passangers');
            }
            if (Schema::hasColumn('vehicles', 'cc')) {
                $table->renameColumn('cc', 'Cc');
            }
        });
    }
};
