<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vehicles', function (Blueprint $table) {
            $table->id();
            $table->string('image')->nullable();
            $table->string('class');
            $table->string('name');
            $table->string('passangers');
            $table->integer('km');
            $table->integer('Cc');
            $table->string('fuel');
            $table->integer('price');
            $table->string('body_type');
            $table->string('transmission');
            $table->string('climate_control');
            $table->integer('mileage');
            $table->year('register_year');
            $table->string('condition');
            $table->string('edition');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vehicles');
    }
};
