<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;
use Illuminate\Support\Str;

class MaxWords implements ValidationRule
{
    public function __construct(private readonly int $maxWords)
    {
    }

    /**
        * @param  \Closure(string, string|null): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        if ($value === null || $value === '') {
            return;
        }

        $text = trim(strip_tags((string) $value));

        if ($text === '') {
            return;
        }

        $words = preg_split('/\s+/u', $text, -1, PREG_SPLIT_NO_EMPTY);
        $count = is_array($words) ? count($words) : 0;

        if ($count > $this->maxWords) {
            $attributeName = (string) Str::of($attribute)
                ->afterLast('.')
                ->replace('_', ' ')
                ->headline();

            $fail($attribute, "The {$attributeName} field may not have more than {$this->maxWords} words.");
        }
    }
}
