<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Currency extends Model
{
    // If your table name is "currencies" you can remove this line.
    protected $table = 'currencies';

    protected $fillable = [
        'name',  
        'code',   
        'symbol',
        'is_default',
    ];

    protected $casts = [
        'name' => 'string',
        'code' => 'string',
        'symbol' => 'string',
        'is_default' => 'bool',
    ];

    protected static function booted(): void
    {
        static::saving(function (Currency $currency) {
            if ($currency->is_default) {
                Currency::query()
                    ->whereKeyNot($currency->getKey())
                    ->update(['is_default' => false]);
            }
        });
    }

    public static function getDefaultSymbol(string $fallback = '$'): string
    {
        $symbol = static::query()
            ->where('is_default', true)
            ->value('symbol');

        $symbol = is_string($symbol) ? trim($symbol) : '';

        return $symbol !== '' ? $symbol : $fallback;
    }

    public static function getDefaultCode(string $fallback = 'USD'): string
    {
        $code = static::query()
            ->where('is_default', true)
            ->value('code');

        $code = is_string($code) ? strtoupper(trim($code)) : '';

        return $code !== '' ? $code : $fallback;
    }
}
