<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;

class VideoGallery extends Model
{
    protected $fillable = [
        'title',
        'video',
        'thumbnail',
        'tiktok_url',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    protected $table = 'videogalleries';

    /**
     * Resolve stored video path for Filament FileUpload.
     */
    public function getVideoAttribute($value)
    {
        if (!$value) {
            return null;
        }

        $value = trim((string) $value);
        
        // If it's a URL, return as-is
        if (str_starts_with($value, 'http://') || str_starts_with($value, 'https://')) {
            return $value;
        }
        
        $value = ltrim($value, '/');

        if (str_starts_with($value, 'storage/')) {
            $value = substr($value, strlen('storage/'));
        }

        return $value;
    }

    /**
     * Full public video URL
     */
    public function getVideoUrlAttribute(): ?string
    {
        $path = $this->video;

        if (!$path) {
            return null;
        }

        try {
            $root = app()->runningInConsole()
                ? config('app.url')
                : request()->getSchemeAndHttpHost();
        } catch (\Throwable $e) {
            $root = config('app.url');
        }

        $root = rtrim((string) $root, '/');

        return $root . '/storage/' . ltrim($path, '/');
    }
}
