<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Make;

class MakeApiController extends Controller
{
    public function index()
    {
        $makes = Make::query()
            ->orderBy('name')
            ->get(['id', 'name', 'logo', 'is_popular'])
            ->map(function ($make) {
                return [
                    'id' => $make->id,
                    'name' => $make->name,
                    'logo' => $make->logo ? asset('storage/' . $make->logo) : null,
                    'is_popular' => $make->is_popular,
                ];
            });

        return response()->json($makes);
    }
}
