<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Imagegallery;

class ImageApiController extends Controller
{
    public function index()
    {
        $root = rtrim(request()->getSchemeAndHttpHost(), '/');
        $base = $root . '/storage/';

        $toPublicUrl = static function (?string $path) use ($root, $base): ?string {
            if (!$path) {
                return null;
            }

            if (str_starts_with($path, 'http://') || str_starts_with($path, 'https://')) {
                return $path;
            }

            if (str_starts_with($path, '/storage/')) {
                return $root . $path;
            }

            return $base . ltrim($path, '/');
        };

        $images = Imagegallery::query()
            ->select(['id', 'title', 'image', 'thumbnail', 'thumbnail_url', 'description'])
            ->latest()
            ->get()
            ->map(function ($g) use ($toPublicUrl) {
                return [
                    'id' => $g->id,
                    'title' => $g->title,
                    'description' => $g->description,
                    'image' => $toPublicUrl($g->image),
                    'thumbnail' => $toPublicUrl($g->thumbnail),
                    'thumbnail_url' => $g->thumbnail_url,
                ];
            });

        return response()->json($images);
    }
}
