<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\HomeVideo;

class HomeApiController extends Controller
{
    public function showCurrent()
    {
        $homeVideo = HomeVideo::query()
            ->orderByDesc('id')
            ->first();

        if (! $homeVideo) {
            return response()->json([
                'status' => 'success',
                'data' => [
                    'title' => 'Welcome to Our Platform',
                    'subtitle' => 'Experience the Best',
                    'description' => 'Discover premium content and modern experiences.',
                    'button_name' => 'Get Started',
                    'video' => null,
                ],
            ]);
        }

        return response()->json([
            'status' => 'success',
            'data' => [
                'id' => $homeVideo->id,
                'title' => $homeVideo->title,
                'subtitle' => $homeVideo->subtitle,
                'description' => $homeVideo->description,
                'button_name' => $homeVideo->button_name,
                'video' => $homeVideo->video,
                'image' => $homeVideo->image,
                'is_image_active' => $homeVideo->is_image_active,
            ],
        ]);
    }
}
