<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Currency;

class CurrencyApiController extends Controller
{
    public function showCurrent()
    {
        $currency = Currency::query()
            ->orderByDesc('is_default')
            ->orderByDesc('id')
            ->first();

        if (! $currency) {
            return response()->json([
                'status' => 'success',
                'data' => [
                    'name' => 'US Dollar',
                    'code' => 'USD',
                    'symbol' => '$',
                    'is_default' => true,
                ],
            ]);
        }

        return response()->json([
            'status' => 'success',
            'data' => [
                'id' => $currency->id,
                'name' => $currency->name,
                'code' => $currency->code,
                'symbol' => $currency->symbol,
                'is_default' => (bool) $currency->is_default,
            ],
        ]);
    }
}
