<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Contact;
use Illuminate\Http\Request;

class ContactApiController extends Controller
{
    public function store(Request $request)
    {
        $validated = $request->validate([
            'firstname' => 'required|string|max:255',
            'lastname'  => 'required|string|max:255',
            'email'     => 'required|email|max:255',
            'phone'     => 'required|string|max:20',
            'message'   => 'required|string',
        ]);

        Contact::create([
            'firstname'    => $validated['firstname'],
            'lastname'     => $validated['lastname'],
            'email'        => $validated['email'],
            'phone_number' => $validated['phone'],
            'message'      => $validated['message'],
        ]);

        return response()->json([
            'status' => 'success',
            'message' => 'Message sent successfully'
        ], 201);
    }
}
