<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Category;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\URL;

class CategoryApiController extends Controller
{
    private function publicImageUrl(?string $path): ?string
    {
        if (!$path) {
            return null;
        }

        if (str_starts_with($path, 'http://') || str_starts_with($path, 'https://')) {
            return $path;
        }

        $path = ltrim($path, '/');
        $path = preg_replace('#^storage/#', '', $path);

        if (!Storage::disk('public')->exists($path)) {
            return null;
        }

        return URL::to('/storage/' . $path);
    }

    public function index()
    {
        $categories = Category::select(
            'id',
            'name',
            'image',
            'description',
            'created_at',
            'updated_at'
        )
            ->latest()
            ->get();

        $categories->transform(function (Category $category) {
            $category->image_url = $this->publicImageUrl($category->image);
            return $category;
        });

        return response()->json($categories);
    }
}
