<?php

namespace App\Filament\Widgets;

use App\Filament\Resources\Imagegalleries\ImagegalleryResource;
use App\Filament\Resources\Users\UserResource;
use App\Filament\Resources\Vehicles\VehicleResource;
use App\Filament\Resources\Videogalleries\VideogalleryResource;
use Filament\Widgets\Widget;
use Illuminate\Support\Facades\Auth;

class QuickActionsWidget extends Widget
{
    protected string $view = 'filament.widgets.quick-actions-widget';

    protected int | string | array $columnSpan = 1;

    public static function canView(): bool
    {
        $user = Auth::user();

        if (! $user) {
            return false;
        }

        if ($user->role === 'super_admin') {
            return true;
        }

        $options = $user->dashboard_options ?? [];

        return ! empty($options);
    }

    protected function getViewData(): array
    {
        return [
            'canVehicles' => $this->hasOption('vehicles'),
            'canImages' => $this->hasOption('image_gallery'),
            'canVideos' => $this->hasOption('video_gallery'),
            'canUsers' => $this->hasOption('users') && (Auth::user()?->role === 'super_admin'),
            'vehicleCreateUrl' => VehicleResource::getUrl('create'),
            'imageCreateUrl' => ImagegalleryResource::getUrl('create'),
            'videoCreateUrl' => VideogalleryResource::getUrl('create'),
            'userCreateUrl' => UserResource::getUrl('create'),
        ];
    }

    private function hasOption(string $option): bool
    {
        $user = Auth::user();

        if (! $user) {
            return false;
        }

        if ($user->role === 'super_admin') {
            return true;
        }

        $options = $user->dashboard_options ?? [];

        return in_array($option, $options, true);
    }
}
