<?php

namespace App\Filament\Widgets;

use App\Filament\Resources\Contacts\ContactResource;
use App\Models\contact;
use Filament\Actions\ViewAction;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;
use Filament\Widgets\TableWidget;
use Illuminate\Support\Facades\Auth;

class LatestContactMessagesWidget extends TableWidget
{
    protected int | string | array $columnSpan = 'full';

    public static function canView(): bool
    {
        $user = Auth::user();

        if (! $user) {
            return false;
        }

        if ($user->role === 'super_admin') {
            return true;
        }

        $options = $user->dashboard_options ?? [];

        return in_array('contacts', $options, true);
    }

    public function table(Table $table): Table
    {
        return $table
            ->heading('Latest Contact Messages')
            ->query(contact::query()->latest('created_at'))
            ->defaultPaginationPageOption(5)
            ->paginationPageOptions([5])
            ->columns([
                TextColumn::make('firstname')->label('First')->searchable(),
                TextColumn::make('lastname')->label('Last')->searchable(),
                TextColumn::make('email')->label('Email')->searchable(),
                TextColumn::make('message')->label('Message')->limit(40)->wrap(),
                TextColumn::make('created_at')->label('Created')->dateTime()->sortable(),
            ])
            ->actions([
                ViewAction::make()
                    ->url(fn ($record) => ContactResource::getUrl('view', ['record' => $record])),
            ]);
    }
}
