<?php

namespace App\Filament\Widgets;

use App\Models\contact;
use App\Models\Imagegallery;
use App\Models\User;
use App\Models\Vehicle;
use App\Models\VideoGallery;
use Filament\Widgets\StatsOverviewWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Carbon;

class DashboardStatsOverview extends StatsOverviewWidget
{
    protected function getStats(): array
    {
        $stats = [];

        if ($this->hasOption('vehicles')) {
            $stats[] = Stat::make('Total Vehicles', Vehicle::query()->count());

            $stats[] = Stat::make(
                'Vehicles Created (Today)',
                Vehicle::query()->whereDate('created_at', Carbon::today())->count(),
            );

            $stats[] = Stat::make(
                'Vehicles Updated (Last 7 Days)',
                Vehicle::query()->where('updated_at', '>=', now()->subDays(7))->count(),
            );
        }

        if ($this->hasOption('users')) {
            $stats[] = Stat::make('Total Users', User::query()->count());
        }

        if ($this->hasOption('contacts')) {
            $stats[] = Stat::make(
                'New Contact Messages (Today)',
                contact::query()->whereDate('created_at', Carbon::today())->count(),
            );
        }

        if ($this->hasOption('image_gallery') || $this->hasOption('video_gallery')) {
            $stats[] = Stat::make(
                'Galleries',
                (int) Imagegallery::query()->count() + (int) VideoGallery::query()->count(),
            );
        }

        return $stats;
    }

    public static function canView(): bool
    {
        $user = Auth::user();

        if (! $user) {
            return false;
        }

        if (in_array($user->role, ['super_admin', 'admin'], true)) {
            return true;
        }

        $options = $user->dashboard_options ?? [];

        return ! empty($options);
    }

    private function hasOption(string $option): bool
    {
        $user = Auth::user();

        if (! $user) {
            return false;
        }

        if (in_array($user->role, ['super_admin', 'admin'], true)) {
            return true;
        }

        $options = $user->dashboard_options ?? [];

        return in_array($option, $options, true);
    }
}
