<?php

namespace App\Filament\Resources\Vehicles\Schemas;

use App\Models\Currency;
use Filament\Infolists\Components\ImageEntry;
use Filament\Infolists\Components\TextEntry;
use Filament\Schemas\Schema;

class VehicleInfolist
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                ImageEntry::make('image')
                    ->disk('public')
                    ->placeholder('-'),
                TextEntry::make('category.name')
                    ->label('Category'),
                TextEntry::make('name')
                    ->label('Car Name'),
                TextEntry::make('make')
                    ->label('Make'),
                TextEntry::make('passengers')
                    ->label('Passengers'),
                TextEntry::make('km')
                    ->label('Mileage (KM)')
                    ->numeric(),
                TextEntry::make('cc')
                    ->label('Engine CC')
                    ->numeric(),
                TextEntry::make('fuel')
                    ->label('Fuel Type'),
                TextEntry::make('price')
                    ->label('Price per Day')
                    ->formatStateUsing(fn ($state) => Currency::getDefaultSymbol('Rs.') . (is_numeric($state) ? number_format((float) $state, 2, '.', ',') : (string) $state)),
                TextEntry::make('body_type')
                    ->label('Body Type'),
                TextEntry::make('transmission')
                    ->label('Transmission'),
                TextEntry::make('climate_control')
                    ->label('Climate Control'),
                TextEntry::make('mileage')
                    ->label('Fuel Mileage (KM/L)')
                    ->numeric(),
                TextEntry::make('register_year')
                    ->label('Register Year'),
                TextEntry::make('condition')
                    ->label('Condition'),
                TextEntry::make('edition')
                    ->label('Edition'),
                TextEntry::make('created_at')
                    ->label('Created At')
                    ->dateTime()
                    ->placeholder('-'),
                TextEntry::make('updated_at')
                    ->label('Updated At')
                    ->dateTime()
                    ->placeholder('-'),
            ]);
    }
}

