<?php

namespace App\Filament\Resources\Vehicles\Schemas;

use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Schemas\Schema;

class VehicleForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                FileUpload::make('image')
                    ->image()
                    ->disk('public')
                    ->directory('vehicles')
                    ->visibility('public'),
                FileUpload::make('schedule_test_drive_pdf')
                    ->label('Schedule Test Drive PDF')
                    ->acceptedFileTypes(['application/pdf'])
                    ->disk('public')
                    ->directory('vehicles/documents')
                    ->visibility('public')
                    ->maxSize(10240)
                    ->helperText('Upload the test drive booking form (Max 10MB)'),
                FileUpload::make('car_brochure_pdf')
                    ->label('Car Brochure PDF')
                    ->acceptedFileTypes(['application/pdf'])
                    ->disk('public')
                    ->directory('vehicles/documents')
                    ->visibility('public')
                    ->maxSize(10240)
                    ->helperText('Upload the vehicle brochure (Max 10MB)'),
                Select::make('category_id')
                    ->label('Category')
                    ->relationship('category', 'name')
                    ->searchable()
                    ->preload()
                    ->nullable(),
                Toggle::make('is_featured')
                    ->label('Featured Vehicle (Premium)')
                    ->helperText('Mark as featured to show in premium inventory')
                    ->default(false),
                Toggle::make('is_popular')
                    ->label('Popular Make')
                    ->helperText('Mark as popular make vehicle')
                    ->default(false),
                TextInput::make('class')
                    ->required(),
                TextInput::make('name')
                    ->required(),
                TextInput::make('passengers')
                    ->label('Passengers')
                    ->required()
                    ->numeric()
                    ->integer()
                    ->minValue(1),
                TextInput::make('km')
                    ->required()
                    ->numeric(),
                TextInput::make('cc')
                    ->label('Engine CC')
                    ->required()
                    ->numeric()
                    ->integer()
                    ->minValue(50),
                TextInput::make('fuel')
                    ->required(),
                TextInput::make('price')
                    ->required()
                    ->numeric()
                    ->prefix('$'),
            ]);
    }
}
