<?php

namespace App\Filament\Resources\Users\Schemas;

use Filament\Forms\Components\DateTimePicker;
use Filament\Forms\Components\Hidden;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Select;
use Filament\Schemas\Schema;
use Filament\Resources\Pages\CreateRecord;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;

class UserForm
{
    public static function configure(Schema $schema): Schema
    {
        $availableOptions = [
            'vehicles' => 'Vehicles',
            'contacts' => 'Contact Messages',
            'image_gallery' => 'Image Gallery',
            'video_gallery' => 'Video Gallery',
            'users' => 'Users',
            'blogs' => 'Blogs',
            'categories' => 'Categories',
            'services' => 'FAQ',
            'currencies' => 'Currencies',
            
        ];

        return $schema
            ->components([
                TextInput::make('name')
                    ->required(),
                TextInput::make('email')
                    ->label('Email address')
                    ->email()
                    ->required(),
                Hidden::make('role')
                    ->default('user')
                    ->dehydrated(true),
                Select::make('dashboard_options')
                    ->label('Options')
                    ->options($availableOptions)
                    ->multiple()
                    ->required()
                    ->default(array_keys($availableOptions))
                    ->afterStateHydrated(function (Select $component, $state) use ($availableOptions): void {
                        $values = array_values(array_filter(
                            (array) $state,
                            fn ($value) => array_key_exists($value, $availableOptions),
                        ));

                        $component->state($values);
                    })
                    ->dehydrateStateUsing(function ($state) use ($availableOptions): array {
                        return array_values(array_filter(
                            (array) $state,
                            fn ($value) => array_key_exists($value, $availableOptions),
                        ));
                    }),
                DateTimePicker::make('email_verified_at'),
                TextInput::make('password')
                    ->password()
                    ->dehydrated(fn ($state) => filled($state))
                    ->dehydrateStateUsing(fn ($state) => $state ? Hash::make($state) : null)
                    ->required(fn ($livewire) => $livewire instanceof CreateRecord),
            ]);
    }
}
