<?php

namespace App\Filament\Resources\Makes\Schemas;

use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Toggle;
use Filament\Schemas\Schema;

class MakeForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('name')
                    ->label('Make Name')
                    ->required()
                    ->unique(ignoreRecord: true)
                    ->maxLength(255),
                FileUpload::make('logo')
                    ->label('Logo')
                    ->image()
                    ->disk('public')
                    ->directory('makes')
                    ->visibility('public')
                    ->nullable(),
                Toggle::make('is_popular')
                    ->label('Popular Make')
                    ->helperText('Mark as popular to feature this make')
                    ->default(false),
            ]);
    }
}
