<?php

namespace App\Filament\Resources\Imagegalleries\Tables;

use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Actions\ViewAction;
use Filament\Tables\Columns\ImageColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class ImagegalleriesTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('title')
                    ->label('Title')
                    ->searchable()
                    ->placeholder('-'),
                ImageColumn::make('image')
                    ->disk('public')
                    ->label('Image'),
                ImageColumn::make('thumbnail')
                    ->disk('public')
                    ->label('Thumbnail')
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('thumbnail_url')
                    ->label('Thumbnail URL')
                    ->limit(35)
                    ->wrap()
                    ->url(fn ($record) => $record->thumbnail_url ?: null, true)
                    ->openUrlInNewTab()
                    ->placeholder('-')
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->recordActions([
                ViewAction::make(),
                EditAction::make(),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);
    }
}
