<?php

namespace App\Filament\Resources\Imagegalleries\Schemas;

use Filament\Infolists\Components\ImageEntry;
use Filament\Infolists\Components\TextEntry;
use Filament\Schemas\Schema;

class ImagegalleryInfolist
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextEntry::make('title')
                    ->label('Title')
                    ->placeholder('-'),
                ImageEntry::make('image')
                    ->disk('public')
                    ->label('Image')
                    ->height(240)
                    ->placeholder('-'),
                ImageEntry::make('thumbnail')
                    ->disk('public')
                    ->label('Thumbnail Image')
                    ->height(140)
                    ->placeholder('-'),
                TextEntry::make('thumbnail_url')
                    ->label('Thumbnail URL')
                    ->url(fn ($record) => $record->thumbnail_url ?: null, true)
                    ->openUrlInNewTab()
                    ->placeholder('-'),
            ]);
    }
}
